<?php
/**
 * File: includes/sb-radius-search.php
 * Purpose: Part of the Speakers Bureau plugin.
 */

if (!defined('ABSPATH')) exit;

function sb_query_speakers_within_radius($lat, $lng, $radius = 50) {
    global $wpdb;
    $sql = $wpdb->prepare("
        SELECT p.ID, 
        ( 3959 * acos(
            cos( radians(%f) ) *
            cos( radians( lat.meta_value ) ) *
            cos( radians( lng.meta_value ) - radians(%f) ) +
            sin( radians(%f) ) *
            sin( radians( lat.meta_value ) )
        ) ) AS distance
        FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} lat ON (p.ID = lat.post_id AND lat.meta_key = '_sb_lat')
        INNER JOIN {$wpdb->postmeta} lng ON (p.ID = lng.post_id AND lng.meta_key = '_sb_lng')
        WHERE p.post_type = 'speaker' AND p.post_status = 'publish'
        HAVING distance < %d
        ORDER BY distance ASC
    ", $lat, $lng, $lat, $radius);

    $results = $wpdb->get_results($sql);
    return wp_list_pluck($results, 'ID');
}

// Allow [speaker_list] query to be filtered by zip & radius
add_filter('sb_speaker_list_query_args', function($args) {
    $zip    = isset($_GET['zip']) ? sanitize_text_field(wp_unslash($_GET['zip'])) : '';
    $radius = isset($_GET['radius']) ? intval($_GET['radius']) : 0;

    if ($zip && $radius > 0) {
        $coords = sb_geocode_address($zip);
        if ($coords) {
            $ids = sb_query_speakers_within_radius($coords['lat'], $coords['lng'], $radius);
            $args['post__in'] = $ids ?: [0];
            $args['orderby']  = 'post__in';
        }
    }
    return $args;
});

/** END OF FILE: includes/sb-radius-search.php */
