<?php
/**
 * File: includes/sb-cpt.php
 * Purpose: Part of the Speakers Bureau plugin.
 */

if (!defined('ABSPATH')) exit;

function sb_register_speaker_cpt() {
    register_post_type('speaker', [
        'labels' => [
            'name'               => __('Speakers','sb'),
            'singular_name'      => __('Speaker','sb'),
            'add_new'            => __('Add New','sb'),
            'add_new_item'       => __('Add New Speaker','sb'),
            'edit_item'          => __('Edit Speaker','sb'),
            'new_item'           => __('New Speaker','sb'),
            'view_item'          => __('View Speaker','sb'),
            'search_items'       => __('Search Speakers','sb'),
            'not_found'          => __('No speakers found','sb'),
            'not_found_in_trash' => __('No speakers found in Trash','sb'),
        ],
        'public'              => true,
        'has_archive'         => true,
        'rewrite'             => ['slug' => 'speaker'],
        'menu_icon'           => 'dashicons-microphone',
        'supports'            => ['title','editor','thumbnail','author','excerpt'],
        'show_in_rest'        => true,  // Enable Gutenberg and REST API
        'publicly_queryable'  => true,
        'exclude_from_search' => false,
        'can_export'          => true,
        'delete_with_user'    => false,
    ]);
}
add_action('init', 'sb_register_speaker_cpt');

/**
 * Temporary: Flush rewrite rules to fix 404 issues after optimization changes
 * This should only run once after the optimization updates
 */
function sb_maybe_flush_rewrite_rules() {
    $flushed = get_option('sb_rewrite_flushed_after_optimization', false);
    if (!$flushed) {
        flush_rewrite_rules();
        update_option('sb_rewrite_flushed_after_optimization', true);
    }
}
add_action('init', 'sb_maybe_flush_rewrite_rules', 20);

/**
 * Ensure speaker post titles are never null to prevent Yoast/WordPress deprecation warnings
 */
function sb_ensure_speaker_title($title, $post_id = null) {
    if (!$post_id) {
        $post_id = get_the_ID();
    }

    if ($post_id && get_post_type($post_id) === 'speaker') {
        // If title is null or empty, provide a default
        if (empty($title)) {
            $speaker_name = get_post_meta($post_id, 'speaker_name', true);
            if (!empty($speaker_name)) {
                return $speaker_name;
            }
            return __('Speaker', 'speakers-bureau') . ' #' . $post_id;
        }
    }

    return $title;
}
add_filter('the_title', 'sb_ensure_speaker_title', 10, 2);
add_filter('wp_title', 'sb_ensure_speaker_title', 10, 2);
add_filter('document_title_parts', function($title_parts) {
    if (is_singular('speaker')) {
        $post_id = get_the_ID();
        if ($post_id && empty($title_parts['title'])) {
            $title_parts['title'] = sb_ensure_speaker_title('', $post_id);
        }
    }
    return $title_parts;
});

/**
 * Prevent null values in admin contexts for speaker posts
 */
function sb_admin_speaker_title_filter($title) {
    global $post;

    if (is_admin() && $post && get_post_type($post) === 'speaker') {
        if (empty($title)) {
            $speaker_name = get_post_meta($post->ID, 'speaker_name', true);
            if (!empty($speaker_name)) {
                return $speaker_name;
            }
            return __('Speaker', 'speakers-bureau') . ' #' . $post->ID;
        }
    }

    return $title;
}
add_filter('admin_title', 'sb_admin_speaker_title_filter');

/** END OF FILE: includes/sb-cpt.php */
