<?php
/**
 * Export current production form builder and profile layout data
 * Run this script once to get the current data for updating plugin defaults
 */

// Load WordPress
require_once '../../../wp-load.php';

// Check if user has admin permissions
if (!current_user_can('manage_options')) {
    die('Access denied - Admin access required');
}

// Get current form builder data
$form_fields = get_option('sb_form_fields', []);

// Get current profile layout data
$profile_layout = get_option('sb_profile_layout', []);

// Get email templates
$email_templates = get_option('sb_email_templates', []);

// Format the data for easy copying
echo "<!DOCTYPE html>\n<html>\n<head><title>Speakers Bureau Production Data Export</title></head>\n<body>\n";
echo "<h1>Speakers Bureau Production Data Export</h1>\n";
echo "<p>Copy the data below to update plugin defaults:</p>\n\n";

echo "<h2>1. Form Builder Fields (sb_form_fields)</h2>\n";
echo "<textarea style='width: 100%; height: 300px; font-family: monospace;'>";
echo "// Form Builder Fields Default Data\n";
echo '$default_form_fields = ' . var_export($form_fields, true) . ';';
echo "</textarea>\n\n";

echo "<h2>2. Profile Layout (sb_profile_layout)</h2>\n";
echo "<textarea style='width: 100%; height: 200px; font-family: monospace;'>";
echo "// Profile Layout Default Data\n";
echo '$default_profile_layout = ' . var_export($profile_layout, true) . ';';
echo "</textarea>\n\n";

echo "<h2>3. Email Templates (sb_email_templates)</h2>\n";
echo "<textarea style='width: 100%; height: 200px; font-family: monospace;'>";
echo "// Email Templates Default Data\n";
echo '$default_email_templates = ' . var_export($email_templates, true) . ';';
echo "</textarea>\n\n";

echo "<h2>4. Summary Information</h2>\n";
echo "<p><strong>Form Fields Count:</strong> " . count($form_fields) . "</p>\n";
echo "<p><strong>Profile Layout Sections:</strong> " . count($profile_layout) . "</p>\n";
echo "<p><strong>Email Templates:</strong> " . count($email_templates) . "</p>\n";

echo "<h3>Form Fields Overview:</h3>\n<ul>\n";
foreach ($form_fields as $index => $field) {
    $label = $field['label'] ?? 'Unnamed';
    $key = $field['key'] ?? 'no-key';
    $type = $field['type'] ?? 'text';
    $enabled = !empty($field['enabled']) ? 'enabled' : 'disabled';
    $section = $field['section'] ?? '?';
    echo "<li>#{$index}: <strong>{$label}</strong> (key: {$key}, type: {$type}, section: {$section}, {$enabled})</li>\n";
}
echo "</ul>\n";

echo "<h3>Profile Layout Sections:</h3>\n<ul>\n";
foreach ($profile_layout as $section_num => $section) {
    $title = $section['title'] ?? 'Untitled';
    $heading = $section['heading'] ?? 'h3';
    $display = !empty($section['display']) ? 'visible' : 'hidden';
    echo "<li>Section {$section_num}: <strong>{$title}</strong> ({$heading}, {$display})</li>\n";
}
echo "</ul>\n";

echo "<h3>Email Templates:</h3>\n<ul>\n";
foreach ($email_templates as $template_key => $template_value) {
    echo "<li><strong>{$template_key}:</strong> " . substr(strip_tags($template_value), 0, 100) . (strlen($template_value) > 100 ? '...' : '') . "</li>\n";
}
echo "</ul>\n";

echo "<hr>\n";
echo "<p><em>Generated on: " . date('Y-m-d H:i:s') . "</em></p>\n";
echo "</body>\n</html>";
?>