/**
 * File: assets/sb-frontend.js
 * Function: Front-end behaviors (media upload for image fields, minor UX)
 */
(function($){
  $(document).ready(function(){

    // Front-end Media Uploader for .sb-upload-btn
    var sbMediaFrame = null;

    function openMedia(frameTitle, inputEl) {
      if (sbMediaFrame) {
        sbMediaFrame.off('select'); // remove previous listener
      }

      sbMediaFrame = wp.media({
        title: frameTitle || 'Select or Upload Image',
        button: { text: 'Use this image' },
        multiple: false
      });

      sbMediaFrame.on('select', function(){
        var attachment = sbMediaFrame.state().get('selection').first().toJSON();
        // Find the text input in the same .sb-upload wrapper
        var $wrapper = $(inputEl).closest('.sb-upload');
        var $input = $wrapper.find('input[type="text"]');
        if ($input.length) {
          $input.val(attachment.url).trigger('change');
        }
      });

      sbMediaFrame.open();
    }

    $(document).on('click', '.sb-upload-btn', function(e){
      e.preventDefault();
      if (typeof wp === 'undefined' || !wp.media) {
        alert('The WordPress Media Library is not available on this page.');
        return;
      }
      openMedia('Select Image', this);
    });

    // Contact Form Modal Functionality
    var $modal = $('#sb-contact-modal');
    var $form = $('#sb-contact-form');
    var $message = $('#sb-contact-message');
    var $captchaQuestion = $('#sb-captcha-question');
    var $captchaHash = $('#sb-captcha-hash');

    // Function to load CAPTCHA
    function loadCaptcha() {
      var ajaxurl = (typeof sbContactData !== 'undefined' && sbContactData.ajaxurl)
        ? sbContactData.ajaxurl
        : '/wp-admin/admin-ajax.php';

      $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
          action: 'sb_get_contact_captcha'
        },
        success: function(response) {
          if (response.success) {
            $captchaQuestion.text('What is ' + response.data.question + '?');
            $captchaHash.val(response.data.hash);
          }
        }
      });
    }

    // Open modal on button click
    $(document).on('click', '.sb-contact-speaker-btn', function(e) {
      e.preventDefault();
      $modal.fadeIn(200);
      $('body').css('overflow', 'hidden');
      $message.removeClass('success error').hide();
      loadCaptcha();
    });

    // Close modal
    function closeModal() {
      $modal.fadeOut(200);
      $('body').css('overflow', '');
    }

    $('.sb-modal-close, .sb-modal-overlay').on('click', closeModal);

    // Close on Escape key
    $(document).on('keydown', function(e) {
      if (e.key === 'Escape' && $modal.is(':visible')) {
        closeModal();
      }
    });

    // Form submission
    $form.on('submit', function(e) {
      e.preventDefault();

      var formData = $form.serialize();
      formData += '&action=sb_contact_speaker';

      // Get nonce from localized data
      var nonce = (typeof sbContactData !== 'undefined' && sbContactData.nonce)
        ? sbContactData.nonce
        : '';

      if (nonce) {
        formData += '&nonce=' + nonce;
      }

      var ajaxurl = (typeof sbContactData !== 'undefined' && sbContactData.ajaxurl)
        ? sbContactData.ajaxurl
        : '/wp-admin/admin-ajax.php';

      // Disable submit button
      var $submitBtn = $form.find('button[type="submit"]');
      var originalText = $submitBtn.text();
      $submitBtn.prop('disabled', true).text('Sending...');

      $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: formData,
        success: function(response) {
          if (response.success) {
            $message.removeClass('error').addClass('success')
              .html(response.data.message).show();
            $form[0].reset();
            loadCaptcha(); // Reload captcha
          } else {
            $message.removeClass('success').addClass('error')
              .html(response.data.message).show();
            loadCaptcha(); // Reload captcha on error
          }
        },
        error: function() {
          $message.removeClass('success').addClass('error')
            .html('An error occurred. Please try again.').show();
          loadCaptcha();
        },
        complete: function() {
          $submitBtn.prop('disabled', false).text(originalText);
        }
      });
    });

  });
})(jQuery);

/* End of file: assets/sb-frontend.js */
// END OF FILE
