jQuery(function($){
  var $tbody = $('.sb-sortable');

  if ($tbody.length && $.fn.sortable){
    $tbody.sortable({
      handle: '.sb-handle',
      axis: 'y',
      update: function(){
        $tbody.find('tr').each(function(i){
          $(this).find('input.sb-order').val(i+1);
        });
      }
    });
  }

  $('#sb-add-field').on('click', function(e){
    e.preventDefault();
    var newKey = prompt('Enter a unique field key (letters, numbers, underscore). Example: instagram');
    if (!newKey) return;
    newKey = newKey.trim().toLowerCase().replace(/[^a-z0-9_]/g,'');
    if (!newKey) return alert('Invalid key.');

    var exists = false;
    $('#sb-fields-table tbody tr').each(function(){
      var code = $(this).find('td:eq(3)').text().trim();
      if (code === newKey) exists = true;
    });
    if (exists) return alert('That key already exists.');

    var idx = $('#sb-fields-table tbody tr').length + 1;
    var pretty = newKey.replace(/_/g,' ').replace(/\b\w/g,function(m){return m.toUpperCase();});

    var html = ''+
      '<tr class="sb-row">'+
        '<td><input type="checkbox" name="form_fields['+newKey+'][enabled]" value="1" checked></td>'+
        '<td><input class="sb-order" type="number" name="form_fields['+newKey+'][order]" value="'+idx+'" style="width:60px"></td>'+
        '<td><input type="text" name="form_fields['+newKey+'][label]" value="'+pretty+'" class="regular-text"></td>'+
        '<td><code>'+newKey+'</code></td>'+
        '<td><select name="form_fields['+newKey+'][type]">'+
          '<option value="text">text</option>'+
          '<option value="textarea">textarea</option>'+
          '<option value="email">email</option>'+
          '<option value="tel">tel</option>'+
          '<option value="url">url</option>'+
          '<option value="image">image</option>'+
        '</select></td>'+
        '<td class="sb-handle">&#x2630;</td>'+
      '</tr>';
    $tbody.append(html);
  });
});
// END OF FILE
