# Speakers Bureau v3.4.9 - Speaker Registration & Profile Management Walkthrough

## Overview

This guide walks you through the complete process of becoming a speaker in the directory, featuring the secure two-step registration system, privacy controls, enhanced profile management, contact form system, mobile-responsive design, and anti-spam protection.

## Getting Started

### Who Can Register?
- Anyone interested in speaking on their expertise topics
- Professionals wanting to share knowledge
- Subject matter experts in various fields
- Consultants and educators
- Industry leaders and practitioners

### What You'll Need
- Valid email address for verification
- Basic contact information
- Professional headshot photo
- Brief biography and expertise description
- Speaking topics and areas of interest
- Password for your account (created during verification)
- Optional: topic-related images and additional contact details

### 🆕 New Privacy Features
- **Privacy Controls**: Mark your email or phone as private on your profile
- **Contact Form**: When contact info is private, visitors can message you through a secure form
- **Email Notifications**: Choose to receive updates when your profile changes
- **Anti-Spam Protection**: Simple math verification for security
- **Mobile Responsive**: Your profile looks great on all devices

## Step 1: Speaker Registration

### Finding the Registration Page

**Method 1: Direct URL**
- Visit your organization's speaker registration page
- Typically located at: `[your-site-url]/register-speaker/`
- Make sure you are **not logged in** to use the two-step registration process

**Method 2: Navigation**
- Look for "Register as Speaker" link on the website
- May be in main navigation, footer, or speaker directory page
- Follow link to registration form

**Important**: If you are already logged into the website, you will see the full registration form immediately. If you are not logged in, you will use the secure two-step registration process.

### Two-Step Registration Process (For Non-Logged Users)

#### Step 1: Email Verification

**Initial Registration Form**
When you visit the registration page while not logged in, you'll see a simplified form asking for only:

- **Full Name**: Your complete name as you want it displayed
- **Email Address**: Valid email for verification (this becomes your login email)
- **Security Check**: Simple math problem to verify you're human (not a bot)

**Submit for Verification**
1. Fill in your name and email address
2. Complete the simple math verification
3. Click "Register" or "Submit"
4. You'll see a message: "Please check your email for verification instructions"
5. Check your email inbox (and spam folder) for the verification email

#### Step 2: Complete Registration

**Email Verification**
1. Open the verification email from the speaker bureau
2. Click the verification link provided
3. You'll be taken to a secure page to complete your registration

**Password Creation**
1. Create a secure password for your account
2. Confirm your password
3. Click "Complete Registration"

**Automatic Login and Profile Completion**
After password setup:
1. You'll be automatically logged into your new account
2. You'll be redirected to the profile editing page with a welcome message
3. You can now complete your full speaker profile with all the detailed information

### Full Registration Form (For Logged Users or After Verification)

#### Required Information

**1. Personal Details**
- **Full Name**: Already filled from verification step
- **Email Address**: Already verified and confirmed
- **Headline**: Brief description of your expertise (e.g., "Digital Marketing Strategist" or "Cybersecurity Expert")

**2. Professional Information**
- **Bio/Biography**: Detailed description of your background, experience, and expertise
  - Include relevant education, certifications, and experience
  - Mention notable achievements or specializations
  - Keep professional but personable
  - Typical length: 100-300 words

**3. Speaking Topics**
- **Topics**: Areas where you can speak or provide expertise
  - List specific topics you're comfortable presenting
  - Include both technical and business topics
  - Use keywords that people might search for
  - Examples: "Cloud Computing", "Leadership Development", "Data Analytics"

#### Optional Information

**4. Organization Details**
- **Organization**: Company or institution you're affiliated with
- **Website**: Your professional or company website
- **Phone**: Contact phone number (specify if you want it public)

**5. Location Information**
- **City**: Your city location
- **State/Province**: Your state or province
- **ZIP/Postal Code**: For location-based searches
- **Country**: Your country (if not automatically detected)

**6. Additional Fields**
- **Available for Online**: Checkbox to indicate if you offer online/virtual speaking
- **Edit Profile Link**: Automatically provided after registration
- **Cell Phone**: Optional secondary contact number
- **Presentation Summary**: Brief description of your typical presentations

**7. Images with Lightbox Display**
- **Profile Photo**: Professional headshot with click-to-enlarge functionality
  - Use high-quality image (400x400 pixels minimum)
  - Professional appearance recommended
  - Clear, well-lit photo
  - Acceptable formats: JPG, PNG, GIF
  - Visitors can click to view full-size in lightbox

- **Topic Images**: Visual representations of your expertise areas
  - Related to your speaking topics
  - Professional quality preferred
  - Can include charts, diagrams, or relevant photos
  - Also display in lightbox when clicked
  - Optional but helpful for visual identification

**8. Social Media Links**
- **Facebook URL**: Your professional Facebook page or profile
- **X/Twitter URL**: Your Twitter/X handle or profile
- **YouTube URL**: Your YouTube channel or profile

### Image Upload Process

**1. Profile Photo Upload**
- Click "Upload" button next to Profile Image field
- Select image file from your computer
- Preview will appear after selection
- Ensure image is clear and professional

**2. Topic Image Upload**
- Click "Upload" button next to Topic Image field
- Choose image that represents your expertise
- Preview displays selected image
- Can upload multiple topic images if form allows

**Image Guidelines**:
- **File Size**: Keep under 2MB for faster loading
- **Dimensions**: Minimum 400x400 pixels for profile photos
- **Quality**: High resolution for best display
- **Content**: Professional, relevant to your expertise
- **Format**: JPG, PNG, or GIF files accepted

### Completing Registration

**1. Review Information**
- Double-check all entered information for accuracy
- Verify contact details are correct
- Confirm speaking topics are well-described
- Check that images uploaded successfully

**2. Submit Registration**
- Click "Submit" or "Complete Registration" button
- Wait for confirmation message
- Note any additional instructions provided

**3. Confirmation and Account Creation**
- Success message confirms registration completion
- Your WordPress user account is automatically created with 'speaker' role
- You receive confirmation email with profile and login information
- Administrator receives notification of new registration
- Your profile is immediately published to the directory (no approval needed)
- You can now log in at the `/account-login/` page

**4. Immediate Access**
- Use your email and the password you created to log in
- Access your profile at `/my-profile/` page
- Make updates or changes anytime

## Step 2: Accessing Your Profile

### Profile Edit Page

**Finding Your Profile**
- Visit the profile management page: `[your-site-url]/my-profile/`
- If not logged in, you'll be automatically redirected to `/account-login/`
- Look for "Edit Profile" or "My Profile" links on the site

**Login Process**
- Go to `[your-site-url]/account-login/`
- Enter your email address and password (created during registration)
- Use "Forgot Password?" link if you need to reset your password
- After login, you'll be redirected back to your intended page
- Or navigate directly to `/my-profile/` after logging in

### Profile Management Interface

**Page Header**
- Your profile title as an H2 heading (better for SEO)
- Profile status indicator (Published/Draft) displayed in top-right
- Professional layout with clear navigation

**Form Layout**
- Same 20 fields as available in registration form
- Pre-populated with your current information
- Organized in logical sections (Profile, Overview, More Information)
- Save button to apply changes

**Available Actions**
- **Edit text fields**: Update any text information
- **🔒 Privacy Controls**: Mark email and phone fields as private
- **📧 Email Notifications**: Control whether you receive update emails
- **Upload new images**: Add photos with lightbox functionality
- **Replace images**: Change current images with new ones
- **Remove images**: Delete images from profile
- **Update contact info**: Modify email, phone, website
- **Revise topics**: Add, remove, or modify speaking topics
- **Update social media**: Modify Facebook, Twitter, YouTube links
- **Toggle online availability**: Update virtual speaking status

## Step 3: Managing Your Images with Lightbox

### Enhanced Image Display Features

**Lightbox Functionality**
All images in speaker profiles now feature click-to-enlarge lightbox display:
- **Click any image** on your public profile to view full-size
- **Smooth overlay** with dark background for better viewing
- **Easy closing** by clicking outside image or close button
- **Mobile-friendly** responsive design

**Profile Photo Management**
- **Upload**: Add new profile photo with lightbox capability
  - Click "Upload" button
  - Select file from computer
  - Preview appears immediately
  - Public visitors can click to enlarge
  - Save profile to confirm

- **Replace**: Change existing photo
  - Click "Replace" button next to current image
  - Select new file
  - Old image is replaced automatically
  - Save to apply changes

- **Remove**: Delete current photo
  - Click "Remove" button
  - Confirms removal
  - Save to finalize deletion

**Topic Image Management**
- Same upload, replace, remove options as profile photo
- All topic images also feature lightbox display
- Can manage multiple topic images
- Each image field operates independently
- Preview shows selected images in admin form
- Visitors see thumbnails that expand to full size when clicked

## 🔒 Privacy Controls (Enhanced in v3.1)

### Field-Level Privacy

You now have complete control over which personal information is displayed publicly:

**Email Privacy**
- Checkbox appears below email field: "Keep this email address private"
- When checked: Email hidden from public profile, still used for login/notifications
- When unchecked: Email displays on public profile for contact purposes

**Phone Privacy**
- Checkbox appears below phone fields: "Keep this phone number private"
- When checked: Phone number hidden from public profile
- When unchecked: Phone displays on public profile as clickable tel: link

**Privacy Benefits**
- ✅ Prevent spam and unwanted contact
- ✅ Control your public information exposure
- ✅ Maintain professional boundaries
- ✅ Still receive important system notifications

### Email Notification Controls

**Update Notification Settings**
At the bottom of your profile edit page, you'll find:

- **Checkbox**: "Send me an email notification when my profile is updated"
- **Default**: Checked for regular users, unchecked for administrators
- **Smart Emails**: Includes your complete profile data in HTML format
- **Admin Copy**: Site administrator automatically receives a copy (BCC)

**What You'll Receive**
- Professional HTML email with your complete speaker listing
- Direct links to view and edit your profile
- Only sent when you choose to receive them
- Immediate delivery after profile updates

### Image Best Practices

**Profile Photo Tips**:
- Use recent, professional headshot
- Good lighting and clear image quality
- Dress appropriately for your field
- Smile and appear approachable
- Avoid busy backgrounds
- Consider that visitors will click to view full-size

**Topic Image Suggestions**:
- Charts or graphs related to your expertise
- Professional photos of you presenting
- Diagrams or infographics you've created
- Industry-relevant stock photos
- Visual representations of concepts you discuss
- High-resolution images look great in lightbox display

## Step 4: Optimizing Your Profile

### Writing Effective Content

**Compelling Headline**
- Concise description of expertise
- Use keywords people search for
- Examples:
  - "Cloud Security Architect"
  - "Executive Leadership Coach"
  - "Digital Transformation Expert"
  - "Sustainable Business Consultant"

**Engaging Biography**
- Start with current role or main expertise
- Include relevant background and experience
- Mention notable achievements or certifications
- Add personal touch while maintaining professionalism
- Use keywords relevant to your topics

**Clear Topic Descriptions**
- Be specific about what you can speak about
- Use industry-standard terminology
- Include both technical and business angles
- Consider your audience's search terms
- Update as your expertise evolves

### Contact Information Strategy

**Email Visibility**
- Consider whether to make email public
- Balance accessibility with privacy
- May receive speaking inquiries directly

**Phone Number Sharing**
- Optional for most profiles
- Useful for urgent speaking opportunities
- Consider separate business line

**Website Links**
- Include professional website or LinkedIn
- Ensure website is current and professional
- Can drive additional traffic to your site

### Search Optimization

**Keyword Usage**
- Include relevant industry keywords in bio
- Use terms people commonly search for
- Balance keyword usage with natural language
- Consider synonyms and related terms

**Location Information**
- Complete address information helps with local searches
- Enables location-based speaker discovery
- Useful for organizations seeking local speakers

## Step 5: Monitoring Your Profile

### Public Profile View

**Viewing Your Profile**
1. Visit the speaker directory page at `/speakers/`
2. Search for your name or topics
3. Click your profile card to view full profile
4. Review how information appears to public
5. Test the lightbox functionality by clicking your images

**Profile Sections** (Organized by configured layout)
- **Section 1 - Profile**: Photo, headline, location, and basic info
- **Section 2 - Overview**: Biography, topics, contact details
- **Section 3 - Topics**: Additional topic information
- **Section 4 - Background**: Professional background details
- **Section 7 - More Information**: Social media links
- All images feature click-to-enlarge lightbox functionality

### Keeping Information Current

**Regular Updates**
- Review profile quarterly or after major changes
- Update bio with new achievements or roles
- Add new speaking topics as expertise grows
- Refresh photos periodically

**Content Refresh**
- Add recent speaking engagements or achievements
- Update organization if you change jobs
- Revise topics based on current interests
- Ensure contact information remains accurate

## Troubleshooting Common Issues

### Access Problems

**Can't Access Profile Edit Page**
- Verify correct URL: `/my-profile/`
- If not logged in, you'll be redirected to `/account-login/`
- Use your email and password from registration
- Clear browser cache and try again

**Forgot Login Information**
- Go to `/account-login/` page
- Click "Forgot Password?" link
- Enter your email address
- Check email for password reset instructions
- Create new password and log in
- Contact administrator if email issues persist

**Two-Step Registration Issues**
- Check spam folder for verification email
- Ensure verification link hasn't expired (24-hour limit)
- Try registering again if verification fails
- Contact administrator for assistance

### Upload Issues

**Images Won't Upload**
- Check file size (should be under 2MB)
- Verify file format (JPG, PNG, GIF)
- Try different browser
- Check internet connection
- Contact administrator if problems persist

**Images Not Displaying**
- Refresh page after upload
- Clear browser cache
- Try uploading again
- Verify image file isn't corrupted
- Test lightbox functionality by clicking images on public profile

**Lightbox Not Working**
- Ensure JavaScript is enabled in your browser
- Clear browser cache and reload page
- Try different browser to test
- Contact administrator if issue persists

### Profile Display Issues

**Information Not Updating**
- Ensure you clicked "Save" after changes
- Refresh page to see updates
- Clear browser cache
- Check for error messages

**Profile Not Appearing in Directory**
- Verify profile is published (contact admin)
- Check that required fields are completed
- Ensure profile hasn't been set to private
- Contact administrator for status check

## Getting Speaking Opportunities

### Making Your Profile Stand Out

**Professional Presentation**
- High-quality profile photo
- Well-written, engaging biography
- Clear, specific topic descriptions
- Complete contact information
- Regular profile updates

**Search Visibility**
- Use relevant keywords in your bio and topics
- Complete location information for local opportunities
- Include varied expertise areas
- Use industry-standard terminology

### Responding to Inquiries

**Contact Preparation**
- Monitor email for speaking inquiries
- Respond promptly to requests
- Have speaker materials ready (bio, photos, topics)
- Be clear about availability and requirements

**Professional Communication**
- Respond professionally to all inquiries
- Provide requested information promptly
- Be clear about speaking fees, travel, etc.
- Follow up appropriately

## Support and Help

### Getting Assistance

**Technical Issues**
- Contact site administrator for technical problems
- Report broken links or error messages
- Get help with login or access issues

**Profile Optimization**
- Ask administrator about best practices
- Request help with image sizing or formatting
- Get guidance on content optimization

**Speaking Opportunities**
- Contact organization directly for speaking inquiries
- Network with other speakers in the directory
- Attend organization events to build relationships

## What's New in Version 3.0

### Enhanced Security
- **Two-Step Registration**: Email verification prevents spam and ensures valid contact information
- **Anti-Spam Protection**: CAPTCHA verification blocks automated registrations
- **Privacy Controls**: Field-level privacy for email and phone information
- **Secure Login**: Frontend authentication with password reset capability
- **Account Protection**: Users create their own secure passwords

### Improved User Experience
- **Simplified Registration**: New users only provide name and email initially, then complete profile after verification
- **Automatic Login**: Users are automatically logged in after email verification and redirected to complete their profile
- **HTML Email Notifications**: Rich email templates with complete profile data
- **Smart Email Controls**: Choose when to receive profile update notifications
- **Lightbox Images**: Click any speaker image to view full-size in beautiful overlay
- **Welcome Messages**: Clear guidance for new users with step-by-step instructions
- **Profile Status**: Clear indicators of profile publication status
- **Better SEO**: Improved heading structure and semantic markup

### Advanced Features
- **Display Customization**: Complete control over directory appearance and layout
- **Privacy Management**: Hide sensitive contact information from public view
- **Social Media Integration**: Facebook, Twitter, and YouTube profile links
- **Online Availability**: Checkbox for virtual speaking capabilities
- **Enhanced Search**: Better search functionality excluding irrelevant results
- **Mobile Responsive**: Optimized display on all devices

---

**Congratulations!** You're now ready to create and manage your speaker profile effectively using the Speakers Bureau v3.4.8 features. Your expertise can help organizations find the right speakers for their events and audiences.

## 🆕 What's New in v3.4.9

### Automatic Updates
- **Seamless Updates**: Plugin now automatically checks for and installs updates
- **WordPress Integration**: Update notifications appear in your WordPress admin dashboard

### Mobile Responsive Design (v3.4.8)
- **Perfect on All Devices**: Your profile displays correctly on phones, tablets, and desktops
- **No Horizontal Scrolling**: Content adapts to screen size automatically
- **Touch-Friendly**: All buttons and forms work great on touch devices

### Enhanced Contact Button
- **Two-Line Layout**: "Send a message to" on first line, your name on second
- **Accommodates Long Names**: New layout handles longer speaker names gracefully
- **Better Visual Hierarchy**: Clear, easy-to-read button text

### Privacy-Aware Contact Form (v3.4.6)
When you mark your email or phone as private, visitors see a "Send a message" button instead:
- **Secure Messaging**: Visitors fill out a contact form with their details
- **CAPTCHA Protection**: Math verification prevents spam
- **Direct Delivery**: Messages come straight to your email
- **Easy Replies**: Reply-To header lets you respond directly to inquirers
- **Admin Copy**: Site administrator receives a copy for records

## Previous Updates - v3.3

- **Topics Index Block**: New Gutenberg block for organized topic browsing
- **Enhanced Discovery**: Site visitors can easily browse speakers by expertise area
- **Search Integration**: Topics link directly to relevant speaker search results
- **Responsive Design**: Topics display beautifully on all device sizes
- **Admin Tools**: Better topic management and analytics for site administrators

## Previous Updates - v3.2

- **Improved Pagination**: Speaker directory pagination now works correctly
- **Better Import System**: Enhanced phone number handling and auto-import features
- **Auto-Publish Option**: Completed profiles can be automatically published
- **PHP 8.x Ready**: Fixed all compatibility warnings for modern WordPress
- **Yoast SEO Support**: Better SEO integration and compatibility

---
**Speakers Bureau v3.4.9**