<?php
/**
 * File: includes/sb-search.php
 * Purpose: Part of the Speakers Bureau plugin.
 */

if (!defined('ABSPATH')) exit;

function sb_posts_join($join) {
    global $wpdb;
    if (is_search() && is_main_query() && (get_query_var('post_type') === 'speaker' || empty(get_query_var('post_type')))) {
        $join .= " LEFT JOIN $wpdb->postmeta sbpm ON ($wpdb->posts.ID = sbpm.post_id) ";
    }
    return $join;
}
add_filter('posts_join', 'sb_posts_join');

function sb_posts_where($where) {
    global $wpdb;
    if (is_search() && is_main_query() && (get_query_var('post_type') === 'speaker' || empty(get_query_var('post_type')))) {
        $search = get_query_var('s');
        if ($search) {
            $like = '%' . $wpdb->esc_like($search) . '%';
            $where .= $wpdb->prepare(" OR (sbpm.meta_value LIKE %s)", $like);
        }
    }
    return $where;
}
add_filter('posts_where', 'sb_posts_where');

function sb_posts_distinct($distinct) {
    if (is_search() && is_main_query() && (get_query_var('post_type') === 'speaker' || empty(get_query_var('post_type')))) {
        return "DISTINCT";
    }
    return $distinct;
}
add_filter('posts_distinct', 'sb_posts_distinct');

/** END OF FILE: includes/sb-search.php */
