(function (wp) {
  var el = wp.element.createElement;
  var Fragment = wp.element.Fragment;
  var registerBlockType = wp.blocks.registerBlockType;
  var components = wp.components;
  var InspectorControls = (wp.blockEditor || wp.editor).InspectorControls;
  var ServerSideRender = wp.serverSideRender || components.ServerSideRender;
  var useSelect = (wp.data && wp.data.useSelect) ? wp.data.useSelect : null;

  /* ---------------- Directory ---------------- */
  function DirEdit(props){
    var a = props.attributes || {};
    function setAttr(k,v){ var n={}; n[k]=v; props.setAttributes(n); }

    var imgSizes = [
      { label: 'Thumbnail', value: 'thumbnail' },
      { label: 'Medium', value: 'medium' },
      { label: 'Large', value: 'large' },
      { label: 'Full', value: 'full' }
    ];

    return el(Fragment, null,
      el(InspectorControls, null,
        el(components.PanelBody, { title:'Directory Options', initialOpen:true },
          el(components.SelectControl, {
            label: 'Layout (empty uses default from Settings)',
            value: a.layout || '',
            options: [
              { label: 'Use Default', value: '' },
              { label: 'Grid', value: 'grid' },
              { label: 'List', value: 'list' }
            ],
            onChange: function(v){ setAttr('layout', v); }
          }),
          el(components.ToggleControl, {
            label: 'Show Search',
            checked: !!a.show_search,
            onChange: function(v){ setAttr('show_search', !!v); }
          }),
          el(components.ToggleControl, {
            label: 'Show Filters',
            checked: !!a.show_filters,
            onChange: function(v){ setAttr('show_filters', !!v); }
          }),
          el(components.RangeControl, {
            label: 'Posts per page (0 uses Settings)',
            min: 0, max: 48,
            value: a.posts_per_page || 0,
            onChange: function(v){ setAttr('posts_per_page', parseInt(v||0,10)); }
          }),
          el(components.SelectControl, {
            label: 'Order By',
            value: a.orderby || 'title',
            options: [
              { label: 'Title', value: 'title' },
              { label: 'Date',  value: 'date'  },
              { label: 'Menu Order', value: 'menu_order' }
            ],
            onChange: function(v){ setAttr('orderby', v); }
          }),
          el(components.SelectControl, {
            label: 'Order',
            value: a.order || 'ASC',
            options: [ {label:'ASC',value:'ASC'}, {label:'DESC',value:'DESC'} ],
            onChange: function(v){ setAttr('order', v); }
          })
        ),
        el(components.PanelBody, { title:'Layout Display', initialOpen:true },
          el(components.RangeControl, {
            label: 'Columns (grid)',
            min: 1, max: 6,
            value: a.columns || 3,
            onChange: function(v){ setAttr('columns', parseInt(v||3,10)); }
          }),
          el(components.SelectControl, {
            label: 'Image size',
            value: a.image_size || 'medium',
            options: imgSizes,
            onChange: function(v){ setAttr('image_size', v); }
          })
        )
      ),
      el(ServerSideRender, { block:'speakers-bureau/speaker-list', attributes:a })
    );
  }
  registerBlockType('speakers-bureau/speaker-list', {
    title: 'Speakers: Directory',
    category: 'speakers-bureau',
    icon: 'groups',
    edit: DirEdit,
    save: function(){ return null; }
  });

  /* ---------------- Register Form ---------------- */
  function RegEdit(p){ return el(ServerSideRender, { block:'speakers-bureau/speaker-register', attributes:p.attributes||{} }); }
  registerBlockType('speakers-bureau/speaker-register', {
    title: 'Speakers: Register Form',
    category: 'speakers-bureau',
    icon: 'welcome-write-blog',
    edit: RegEdit,
    save: function(){ return null; }
  });

  /* ---------------- Edit Profile ---------------- */
  function ProfEdit(p){ return el(ServerSideRender, { block:'speakers-bureau/speaker-edit', attributes:p.attributes||{} }); }
  registerBlockType('speakers-bureau/speaker-edit', {
    title: 'Speakers: Edit Profile',
    category: 'speakers-bureau',
    icon: 'admin-users',
    edit: ProfEdit,
    save: function(){ return null; }
  });

  /* ---------------- Profile (Auto/Selector) ---------------- */
  function ProfFullEdit(props){
    var a = props.attributes || {};
    function setAttr(k,v){ var n={}; n[k]=v; props.setAttributes(n); }

    // Fetch all Speakers for selector
    var speakerOptions = [];
    if (useSelect) {
      var posts = useSelect(function(select){
        return select('core').getEntityRecords('postType','speaker',{ per_page: -1 });
      }, []);
      if (posts && posts.length) {
        speakerOptions = posts.map(function(p){
          return { label: (p.title && p.title.rendered) ? p.title.rendered : ('ID '+p.id), value: p.id };
        });
      }
    }

    var showSelector = (a.use_current === false);

    return el(Fragment, null,
      el(InspectorControls, null,
        el(components.PanelBody, { title:'Speaker Source', initialOpen:true },
          el(components.ToggleControl, {
            label: 'Auto (current speaker)',
            checked: a.use_current !== false,
            onChange: function(v){ setAttr('use_current', !!v); if (v) setAttr('post_id', 0); }
          }),
          showSelector && (
            (speakerOptions.length > 0)
              ? el(components.ComboboxControl, {
                  label: 'Select Speaker',
                  value: a.post_id || '',
                  options: speakerOptions,
                  onChange: function(v){ setAttr('post_id', parseInt(v||0,10)||0); }
                })
              : el(components.TextControl, {
                  label: 'Speaker ID',
                  type: 'number',
                  value: a.post_id || '',
                  onChange: function(v){ setAttr('post_id', parseInt(v||0,10)||0); }
                })
          )
        ),
        el(components.PanelBody, { title:'Layout', initialOpen:true },
          el(components.SelectControl, {
            label: 'Layout style',
            value: a.layout || 'stack',
            options: [{label:'Stack',value:'stack'},{label:'Two Columns',value:'two'}],
            onChange: function(v){ setAttr('layout', v); }
          }),
          (a.layout === 'two') && el(components.RangeControl, {
            label: 'Columns',
            min: 1, max: 3,
            value: a.columns || 2,
            onChange: function(v){ setAttr('columns', parseInt(v||2,10)); }
          }),
          el(components.SelectControl, {
            label: 'Image size',
            value: a.image_size || 'medium',
            options: [
              { label:'Thumbnail', value:'thumbnail' },
              { label:'Medium',    value:'medium' },
              { label:'Large',     value:'large' },
              { label:'Full',      value:'full' }
            ],
            onChange: function(v){ setAttr('image_size', v); }
          }),
          el(components.ToggleControl, { label:'Show headshot', checked:!!a.show_headshot, onChange:function(v){ setAttr('show_headshot', !!v); } }),
          el(components.ToggleControl, { label:'Show name',     checked:!!a.show_name,     onChange:function(v){ setAttr('show_name', !!v); } })
        ),
        el(components.PanelBody, { title:'Details', initialOpen:false },
          el(components.ToggleControl, { label:'Location: City',    checked:!!a.show_city,    onChange:function(v){ setAttr('show_city', !!v); } }),
          el(components.ToggleControl, { label:'Location: State',   checked:!!a.show_state,   onChange:function(v){ setAttr('show_state', !!v); } }),
          el(components.ToggleControl, { label:'Location: Country', checked:!!a.show_country, onChange:function(v){ setAttr('show_country', !!v); } }),
          el(components.ToggleControl, { label:'Topics',            checked:!!a.show_topics,  onChange:function(v){ setAttr('show_topics', !!v); } })
        ),
        el(components.PanelBody, { title:'Contact & Links', initialOpen:false },
          el(components.ToggleControl, { label:'Email',     checked:!!a.show_email,    onChange:function(v){ setAttr('show_email', !!v); } }),
          el(components.ToggleControl, { label:'Phone',     checked:!!a.show_phone,    onChange:function(v){ setAttr('show_phone', !!v); } }),
          el(components.ToggleControl, { label:'Website',   checked:!!a.show_website,  onChange:function(v){ setAttr('show_website', !!v); } }),
          el(components.ToggleControl, { label:'LinkedIn',  checked:!!a.show_linkedin, onChange:function(v){ setAttr('show_linkedin', !!v); } }),
          el(components.ToggleControl, { label:'YouTube',   checked:!!a.show_youtube,  onChange:function(v){ setAttr('show_youtube', !!v); } }),
          el(components.ToggleControl, { label:'Show CTA buttons', checked:!!a.show_buttons, onChange:function(v){ setAttr('show_buttons', !!v); } })
        ),
        el(components.PanelBody, { title:'Bio', initialOpen:false },
          el(components.ToggleControl, { label:'Short bio', checked:!!a.show_short_bio, onChange:function(v){ setAttr('show_short_bio', !!v); } }),
          el(components.ToggleControl, { label:'Long bio',  checked:!!a.show_long_bio,  onChange:function(v){ setAttr('show_long_bio',  !!v); } })
        )
      ),
      el(ServerSideRender, { block:'speakers-bureau/speaker-profile', attributes:a })
    );
  }
  registerBlockType('speakers-bureau/speaker-profile', {
    title: 'Speakers: Profile',
    category: 'speakers-bureau',
    icon: 'id',
    attributes: { use_current: { type:'boolean', default:true } },
    edit: ProfFullEdit,
    save: function(){ return null; }
  });

})(window.wp);
// END OF FILE
