# Speakers Bureau WordPress Plugin v3.4

A comprehensive WordPress plugin for managing speaker directories with advanced features including interactive maps, privacy controls, HTML email system, display customization, anti-spam protection, and complete customization options.

## 🌟 What's New in Version 3.4.3

### 🔍 **Enhanced Location Search**
- **Cookie Persistence**: Search parameters (zip, country, radius) are saved in browser cookies and auto-populate on return visits
- **Dynamic Country Dropdown**: Country options now load from form builder database for consistency across registration and search
- **Country Filtering**: Search results now properly filtered by selected country (prevents cross-country results)
- **Smart Reset Button**: New "Reset" button clears all location filters, cookies, and reloads without parameters
- **Location Filter Indicator**: Button text changes to "Location Filter" when filters are active for clear visual feedback
- **Cleaner Interface**: Location form hidden by default until user clicks to expand
- **Auto-Clear on Empty**: Removing ZIP code automatically clears all saved location cookies

### 🎯 **User Experience Improvements**
- **Visual Feedback**: Clear indication when location filters are applied vs. no filters
- **Seamless Navigation**: Return to search page with saved filters intact
- **Easy Reset**: One-click to remove all location parameters and start fresh
- **Consistent Data**: Country values match exactly between speaker profiles and search interface

## Previous Updates - Version 3.4.2

### 🗺️ **Interactive Speaker Maps**
- **LeafletJS Integration**: Display all speakers on an interactive map
- **Smart Markers**: Profile photos, names, headlines, and topics in map popups
- **Automatic Location**: Uses existing geocoding data for instant mapping
- **Overlap Handling**: Multiple speakers at same location show as separate nearby markers
- **Responsive Design**: Mobile-friendly map interface with touch controls
- **Shortcode Support**: `[speaker_map]` with customizable height, width, and zoom
- **One-Click Profiles**: Click markers to view speaker details and profile links

## Previous Updates - Version 3.3

### 📋 **Speaker Topics Index Block**
- **Gutenberg Block**: "Speaker Topics Index" block for organized topic browsing
- **Responsive Layout**: 1-6 column grid that adapts to screen size
- **Smart Sorting**: Alphabetical or popularity-based topic organization
- **Search Integration**: Each topic links to filtered speaker search results
- **Configurable Display**: Show/hide speaker counts, customize columns
- **Shortcode Support**: `[speaker_topics_index]` for classic editor users

### 🔧 **Enhanced Content Management**
- **Automatic Topic Extraction**: Processes all speaker topics intelligently
- **Duplicate Handling**: Consolidates similar topics with proper formatting
- **Block Editor Integration**: Custom "Speakers Bureau" block category
- **Topic Analytics**: See how many speakers cover each topic area

## Previous Updates - Version 3.2

### 🔧 **Bug Fixes & Compatibility**
- **Fixed Pagination**: Speaker directory pagination now works correctly with pretty permalinks
- **PHP 8.x Compatibility**: Fixed deprecated warnings for `str_starts_with()` and `strip_tags()`
- **Yoast SEO Support**: Added compatibility with Yoast SEO plugin and null title prevention
- **Search Parameter Handling**: Improved my-profile page to handle search parameters correctly

### 📞 **Enhanced Import System**
- **Phone Number Consolidation**: All phone types (Home, Office, Cell, Mobile) now map to single phone field
- **Auto-Import Functionality**: Enhanced bulk import with progress tracking and controls
- **Import Process Fixes**: Resolved scan vs preview mismatch in speaker detection

### ⚡ **User Experience Improvements**
- **Auto-Publish Option**: Optional auto-publishing for speaker profiles when required fields are completed
- **Pagination Styling**: Improved pagination navigation with proper button styling
- **Admin Search**: Preserved admin speaker search functionality while fixing core warnings

## Previous Updates - Version 3.1

### 🔒 **Privacy Controls**
- **Field-Level Privacy**: Users can mark email and phone fields as private
- **Smart Display Logic**: Private fields hidden from public profiles automatically
- **Registration & Edit Forms**: Privacy checkboxes with clear explanations
- **Seamless Integration**: Works across all templates and email notifications

### 📧 **Enhanced Email System**
- **HTML Email Templates**: Rich text editing with WordPress editor
- **Profile Update Notifications**: Complete speaker listing in emails
- **New Shortcodes**: `{speaker_listing}`, `{my_profile_url}` for better emails
- **Auto-BCC Admin**: All user emails automatically copy site administrator
- **Smart Email Settings**: Checkbox control for update notifications

### 🎨 **Display Customization**
- **New Display Settings Tab**: Complete control over directory appearance
- **Grid Layout Options**: 1-6 columns with responsive design
- **Card Customization**: Choose fields, styling, shadows, and colors
- **Image Styles**: Square, circle, or rounded speaker photos
- **Content Control**: Word limits, excerpts, and field selection

### 🛡️ **Anti-Spam Protection**
- **Smart CAPTCHA**: Math-based verification for non-logged users
- **Bot Prevention**: Effective spam blocking without external services
- **User-Friendly Design**: Attractive interface with clear instructions
- **Skip for Authenticated**: No CAPTCHA for logged-in users

## 🌟 What's New in Version 3.0

### 🔐 **Two-Step Registration System**
- **Simplified Initial Form**: New users provide only name and email for verification
- **Secure Email Verification**: Non-logged users verify email before completing registration
- **Automatic Login**: Users are logged in automatically after verification
- **Profile Completion**: Redirected to complete full profile after authentication
- **Password Setup**: Users create their own secure passwords after verification
- **UUID Token System**: 24-hour expiration with automatic cleanup
- **Admin Override**: Logged-in users and admins use immediate registration

### 📥 **Configuration Export/Import**
- **Backup Settings**: Export form fields, profile layouts, and email templates
- **Site Migration**: Transfer configurations between installations
- **Merge or Replace**: Choose how to handle existing settings
- **Version Tracking**: Export includes metadata for compatibility

### 🖼️ **Enhanced Image Features**
- **Lightbox Display**: Click images to view full-size versions
- **Responsive Images**: Automatically constrained to column widths
- **Upload Management**: Secure frontend image upload with validation

## 🎯 Core Features

### 📋 **Speaker Management**
- **Custom Post Type**: Dedicated speaker profiles with rich metadata
- **Profile Status**: Draft/Published workflow with status indicators
- **User Roles**: Automatic 'speaker' role creation and management
- **Topics Index**: Organized browsing of all speaker expertise areas
- **Access Control**: Speakers can only edit their own profiles

### 🔍 **Advanced Search & Filtering**
- **Smart Search**: Keyword search across all searchable custom fields
- **Geo-Location**: Find speakers within radius of ZIP code/postal code
- **Distance Sorting**: "Nearest" sorting option with coordinate caching
- **Global Support**: Works with international addresses and postal codes

### 📝 **Dynamic Form Builder**
- **Drag & Drop Interface**: Reorder fields with visual controls
- **20+ Field Types**: Text, email, phone, URL, textarea, select, checkbox, image
- **Smart Validation**: Built-in validation for email, phone, URL fields
- **Privacy Controls**: Field-level privacy settings for sensitive data
- **Section Organization**: Group fields into logical profile sections
- **Search Integration**: Mark fields as searchable for directory filtering

### 🎨 **Profile Layout Customization**
- **8 Configurable Sections**: Customize titles, headings, and visibility
- **Responsive Grid**: CSS Grid layout adapts to all screen sizes
- **Heading Hierarchy**: Choose H1-H6 tags for proper SEO structure
- **Hide/Show Sections**: Control which sections appear on profiles

### 📧 **Advanced Email System**
- **HTML Email Templates**: Rich text editing with WordPress visual editor
- **Profile Update Notifications**: Automatic emails with complete speaker data
- **Enhanced Shortcodes**: `{speaker_listing}`, `{my_profile_url}`, and more
- **Smart Email Controls**: User-controlled notification preferences
- **Auto-BCC Admin**: Automatic admin copies of all user emails
- **Test Email Function**: Send test emails to verify template formatting
- **Multi-Language Ready**: All text strings are translation-ready

### 🔑 **Authentication & Security**
- **Frontend Login**: Beautiful, responsive login/logout experience
- **Anti-Spam Protection**: CAPTCHA verification for registration forms
- **Privacy Controls**: Field-level privacy for sensitive information
- **Password Reset**: Integrated password reset on same page
- **Auto-Redirect**: Automatic login redirect to intended pages
- **Role Restrictions**: Speakers can't access wp-admin
- **Nonce Protection**: All forms secured with WordPress nonces

## 🛠️ Technical Features

### 🌐 **Pages & Shortcodes**
- **Auto-Generated Pages**: `/account-login/`, `/my-profile/`, `/register-speaker/`
- **Template System**: Customizable through theme overrides
- **Shortcode Support**: `[speaker_list]`, `[speaker_map]`, `[speaker_topics_index]`, `[sb_login]`, `[sb_speaker_edit]`, `[sb_speaker_register]`

### 📋 **Topics Index Block & Shortcode**
- **Gutenberg Block**: "Speaker Topics Index" in block editor
- **Responsive Grid**: 1-6 column layout adapting to screen size
- **Smart Topic Processing**: Automatic extraction and consolidation
- **Search Integration**: Each topic links to filtered speaker results
- **Configurable Options**: Show/hide counts, alphabetical/popularity sorting
- **Shortcode Parameters**: `[speaker_topics_index columns="4" show_counts="yes" sort="alphabetical"]`

### 🗺️ **Interactive Speaker Map**
- **LeafletJS Mapping**: Interactive maps powered by OpenStreetMap
- **Rich Popups**: Profile photo, name, headline, organization, and topics
- **Smart Markers**: Automatic offset for speakers at same location
- **Auto-Centering**: Map automatically centers to show all speakers
- **Customizable Display**: Configure height, width, zoom level, and center point
- **Shortcode Parameters**: `[speaker_map height="600px" width="100%" zoom="4"]`
- **Touch-Friendly**: Responsive design for mobile and tablet devices

### 📊 **Admin Interface**
- **Settings Dashboard**: Comprehensive admin panel with tabbed interface
- **Form Builder**: Visual form designer with live preview
- **Email Templates**: Rich text editor for email customization
- **Profile Layout**: Section-by-section layout configuration
- **Display Settings**: Complete visual customization controls
- **Export/Import**: Backup and restore configurations

### 🎨 **Display Customization**
- **Visual Settings Tab**: Complete control over directory appearance
- **Grid Layout Control**: 1-6 columns with responsive breakpoints
- **Card Styling Options**: Multiple styles (default, compact, detailed)
- **Image Shape Control**: Square, circle, or rounded speaker photos
- **Content Management**: Field selection, word limits, and excerpts
- **Color & Shadow Control**: Primary colors and drop shadow effects
- **Mobile Responsive**: Automatic layout adjustments for all devices

### 🗃️ **Database & Performance**
- **Efficient Queries**: Optimized database queries with proper indexing
- **Geocoding Cache**: Coordinates cached to reduce API calls
- **Asset Management**: CSS/JS only loaded when needed
- **Image Optimization**: Proper WordPress media handling

### 🌍 **Geocoding & Location**
- **OpenStreetMap Integration**: Free, reliable geocoding service with country filtering
- **Country-Aware Geocoding**: Uses country field or default country setting for accuracy
- **Coordinate Storage**: Latitude/longitude stored for fast distance calculations
- **Bulk Rebuild**: Admin tool to rebuild all speaker coordinates
- **Fallback Handling**: Graceful degradation when geocoding unavailable
- **Multi-Country Support**: Handles international addresses with proper country codes

## 📋 Default Configuration

### Form Fields (20 fields included):
**Profile Section:**
- Profile Image, Headline, Organization
- City, State, Zip Code, Country
- Available for Online, Edit Profile Link

**Overview Section:**
- Topics, Bio, Email, Phone, Website, Cell Phone
- Topic Image, Presentation Summary

**More Information Section:**
- Facebook URL, X/Twitter URL, YouTube URL

### Profile Layout:
- **Section 1**: Profile (Personal info and location)
- **Section 2**: Overview (Bio, topics, contact details)
- **Section 3**: Topics (Available for expansion)
- **Section 4**: Background (Available for expansion)
- **Section 7**: More Information (Social media links)

## 🔧 Installation & Setup

1. **Upload Plugin**: Extract to `/wp-content/plugins/speakers-bureau/`
2. **Activate**: Enable through WordPress admin
3. **Configure Settings**: Visit Settings → Speakers Bureau
4. **Customize Forms**: Use Form Builder to adjust fields
5. **Test Registration**: Try the registration process
6. **Import/Export**: Use provided configurations or create your own

## 💡 Usage Examples

### For Site Administrators:
- Create speaker profiles for existing speakers
- Customize registration forms for specific needs
- Manage speaker approval workflow
- Export configurations for backup/migration

### For Speakers:
- Register through secure two-step process
- Upload profile and topic images
- Update contact information and bio
- View public profile and edit link

### For Site Visitors:
- Search speakers by keyword and location
- View detailed speaker profiles with images
- Contact speakers through provided information
- Use responsive interface on any device

## 🆘 Support & Documentation

- **Installation Guide**: See `INSTALLATION.md`
- **Speaker Tutorial**: See `SPEAKER-WALKTHROUGH.md`
- **Admin Documentation**: Available in Settings → Docs tab
- **Template Customization**: Override templates in theme folder

## 📈 Version History

### v3.4.0 (Latest)
- ✅ Added LeafletJS interactive map integration for displaying speaker locations
- ✅ Created [speaker_map] shortcode with customizable display options
- ✅ Rich map popups with profile photo, headline, organization, and topics
- ✅ Smart marker positioning for multiple speakers at same location
- ✅ Automatic geocoding integration with existing location data
- ✅ Responsive map design with mobile-friendly touch controls

### v3.3.0
- ✅ Added Speaker Topics Index Gutenberg block for organized topic browsing
- ✅ Created [speaker_topics_index] shortcode with customizable display options
- ✅ Enhanced topic extraction and processing from speaker profiles
- ✅ Added responsive grid layout with search integration
- ✅ Improved block editor integration with custom category

### v3.2.0
- ✅ Fixed pagination functionality in speaker directory
- ✅ Enhanced phone number consolidation in import process
- ✅ Added auto-publish option for completed speaker profiles
- ✅ Fixed PHP 8.x deprecated warnings compatibility
- ✅ Added Yoast SEO compatibility and null title prevention
- ✅ Improved search parameter handling on profile pages
- ✅ Enhanced auto-import functionality with progress tracking

### v3.1.0
- ✅ Privacy controls for email and phone fields
- ✅ HTML email system with rich text editing
- ✅ Profile update email notifications
- ✅ Display settings tab for complete customization
- ✅ CAPTCHA anti-spam protection
- ✅ Enhanced import system improvements
- ✅ Improved user experience and styling

### v3.0.0
- ✅ Two-step email verification registration
- ✅ Configuration export/import system
- ✅ Image lightbox functionality
- ✅ Enhanced email templates with login handling
- ✅ Improved authentication flow
- ✅ Production-ready default configuration

### v2.6.1
- ✅ Form builder stability improvements
- ✅ Search functionality enhancements
- ✅ Image upload system overhaul
- ✅ Geographic search capabilities

## 🔒 Security Features

- **Input Sanitization**: All user input properly sanitized
- **SQL Injection Protection**: Prepared statements throughout
- **XSS Prevention**: Output escaping on all displayed data
- **File Upload Security**: Restricted file types and validation
- **Access Controls**: Proper capability checks for all admin functions
- **CSRF Protection**: Nonces on all forms and actions

## 🎨 Customization

The plugin is built for customization:
- **Template Overrides**: Copy templates to your theme
- **CSS Customization**: Enqueue custom styles
- **Hook System**: Extensive action and filter hooks
- **Translation Ready**: All strings use WordPress i18n functions

---

**Speakers Bureau v3.4** - Professional speaker directory management for WordPress with interactive mapping.