# Speakers Bureau Plugin v3.3 - Installation Guide

## Overview
The Speakers Bureau plugin is a comprehensive WordPress solution for managing speaker directories with advanced features including privacy controls, HTML email system, display customization, anti-spam protection, two-step registration, configuration export/import, image lightbox, geo-location search, Topics Index block, and complete profile management capabilities.

## Requirements
- **WordPress**: 5.0 or higher
- **PHP**: 7.4 or higher
- **MySQL**: 5.6 or higher
- **WordPress Permissions**: Administrator access required for installation and configuration
- **Email Service**: Required for two-step registration verification emails

## Installation Steps

### 1. Plugin Installation

#### Option A: Manual Installation (Recommended)
1. Download the plugin files to your computer
2. Upload the entire `speakers-bureau` folder to `/wp-content/plugins/` directory
3. Go to **WordPress Admin → Plugins**
4. Find "Speakers Bureau" in the plugin list
5. Click **Activate**

#### Option B: ZIP Upload
1. Go to **WordPress Admin → Plugins → Add New**
2. Click **Upload Plugin**
3. Choose the `speakers-bureau.zip` file
4. Click **Install Now**
5. Click **Activate Plugin**

### 2. Initial Configuration

After activation, the plugin automatically:
- Creates the `speaker` custom post type
- Sets up 20 production-ready form fields
- Creates necessary database tables and meta fields
- Configures default profile layout (8 sections)
- Sets up email templates for two-step registration
- Creates 'speaker' user role with appropriate capabilities

### 3. Access Plugin Settings

Navigate to **WordPress Admin → Speakers Bureau** to access:
- **General**: Basic settings, export/import configurations
- **Form Builder**: Customize registration and profile fields (20 default fields)
- **Profile Layout**: Organize speaker profile display (8 configurable sections)
- **Directory Options**: Search and geo-location settings
- **Email Templates**: Configure two-step registration and notification emails
- **Documentation**: Plugin usage guides and shortcode reference

### 4. Required Pages Setup

#### Automatic Page Creation
Go to **Speakers Bureau → General** and click **"Create Required Pages"** to automatically create:

- `/speakers/` - Main speaker directory with search and lightbox (uses shortcode `[speaker_list]`)
- `/register-speaker/` - Two-step registration for new speakers (uses shortcode `[speaker_register]`)
- `/my-profile/` - Speaker profile editing with authentication redirect (uses shortcode `[speaker_edit]`)
- `/account-login/` - Frontend login with password reset functionality (uses shortcode `[sb_login]`)

#### Manual Page Creation (Alternative)
If automatic creation fails, manually create these pages:

**1. Speakers Directory Page:**
- Title: "Speakers" or "Browse Speakers"
- Slug: `speakers`
- Content: `[speaker_list]`
- Publish

**2. Speaker Registration Page:**
- Title: "Register as Speaker"
- Slug: `register-speaker`
- Content: `[speaker_register]`
- Publish

**3. Profile Edit Page:**
- Title: "My Profile"
- Slug: `my-profile`
- Content: `[speaker_edit]`
- Publish

**4. Login Page:**
- Title: "Account Login"
- Slug: `account-login`
- Content: `[sb_login]`
- Publish

### 5. Configure Directory Options

Go to **Speakers Bureau → Directory Options**:

#### Basic Settings
- **Enable geo/radius search**: ☑️ Check to enable location-based search
- **Default country code**: Enter two-letter code (e.g., "US", "CA", "GB")
- **Default radius (miles)**: Set default search radius (e.g., 50)
- **Enable "Nearest" sort**: ☑️ Check to add distance sorting option

#### Save Settings
Click **Save Changes** to apply your configuration.

## Post-Installation Setup

### 1. Review Default Form Configuration
1. Go to **Speakers Bureau → Form Builder**
2. Review the 20 production-ready default fields:
   - **profile_image**: Speaker photo with lightbox functionality
   - **headline**: Brief speaker description
   - **organization**: Company/organization
   - **city, state, zip_code, country**: Location fields for geo-search
   - **available_online**: Online availability checkbox
   - **topics**: Speaking topics (searchable)
   - **bio**: Full biography (searchable)
   - **email, phone, website, cell_phone**: Contact information
   - **topic_image**: Topic-related image
   - **presentation_summary**: Summary of presentations
   - **facebook_url, x_twitter_url, youtube_url**: Social media links

3. Customize any field as needed:
   - **Type**: text, textarea, email, url, image, checkbox, select
   - **Required**: Whether field is mandatory
   - **Searchable**: Include in search functionality
   - **Section**: Which profile section to display in (1-8)
   - **Enabled**: Show/hide field in forms

4. Click **Save Form** after any changes

### 2. Review Profile Layout Configuration
1. Go to **Speakers Bureau → Profile Layout**
2. Review the default 8-section layout:
   - **Section 1: Profile** (Personal info and location) - Left column
   - **Section 2: Overview** (Bio, topics, contact) - Right column
   - **Section 3: Topics** (Available for expansion) - Right column
   - **Section 4: Background** (Available for expansion) - Right column
   - **Section 5: Unused** (Available for expansion)
   - **Section 6: Unused** (Available for expansion)
   - **Section 7: More Information** (Social media) - Full width
   - **Section 8: Private** (Admin-only fields)

3. Customize sections as needed:
   - **Title**: Section heading text
   - **Heading Tag**: h2, h3, h4, etc. for SEO hierarchy
   - **Display**: Show/hide section title
   - **Hidden**: Hide entire section

4. Click **Save Layout** after any changes

### 3. Configure Email Templates
1. Go to **Speakers Bureau → Email Templates**
2. Review and customize the default email templates:
   - **Speaker Confirmation**: Sent after successful registration or profile updates
   - **Admin Notification**: Sent to administrators when speakers register or update profiles
   - **Two-Step Verification**: Sent during email verification process (auto-configured)

3. Use available shortcodes in templates:
   - `{speaker_name}`: Speaker's full name
   - `{profile_url}`: Direct link to speaker's profile page
   - `{public_profile_url}`: Public link to speaker's profile
   - `{site_name}`: Your website name
   - `{login_url}`: Link to login page for existing users

4. Test email functionality using the "Send Test Email" button

### 4. Enable Geo-Location Features (Optional)

If you enabled geo search, speakers can be searched by location:

#### Requirements
- Speakers must have address information (city, state, ZIP)
- Coordinates must be generated for location search

#### Bulk Geocoding
1. Go to **Speakers Bureau → General → Maintenance**
2. Click **"Rebuild All Coordinates"**
3. This converts speaker addresses to latitude/longitude coordinates using OpenStreetMap
4. Required for geo-location search functionality
5. Coordinates are cached to improve performance

## Verification Steps

### 1. Test Speaker Directory
1. Visit your `/speakers/` page
2. Verify you see:
   - Search form with text input
   - "Location..." button (if geo enabled)
   - Sort dropdown with "Nearest" option (if enabled)
   - Speaker cards in responsive grid layout
   - Clickable speaker images that open in lightbox

### 2. Test Two-Step Registration
1. Visit your `/register-speaker/` page (while logged out)
2. Enter email address and name
3. Verify:
   - Verification email is sent
   - Email contains verification link
   - Link leads to password setup page
   - Profile creation works after password setup

### 3. Test Authentication
1. Visit your `/account-login/` page
2. Test login with existing credentials
3. Test "Forgot Password" functionality
4. Visit `/my-profile/` while logged out (should redirect to login)

### 4. Test Profile Editing
1. Visit your `/my-profile/` page (while logged in)
2. Verify edit form loads with profile status indicator
3. Test image upload functionality with validation
4. Save changes and verify updates appear correctly

### 5. Test Search Functionality
1. On `/speakers/` page, search for existing speaker data
2. Test keyword search across searchable fields (topics, bio, etc.)
3. Verify attachments/images don't appear in search results
4. If geo enabled, test location search:
   - Click "Location..." button
   - Enter ZIP code and radius
   - Select "Nearest" sorting
   - Verify distance-based results

### 6. Test Export/Import (Optional)
1. Go to **Speakers Bureau → General**
2. Click **"Export Configuration"** to download current settings
3. Make a small change to form fields or layout
4. Use **"Import Configuration"** to restore previous settings
5. Verify settings are restored correctly

## Troubleshooting

### Common Issues

**Two-step registration not working:**
- Verify WordPress can send emails (test with password reset)
- Check spam folders for verification emails
- Ensure /register-speaker/ page exists with correct shortcode
- Verify email templates are properly configured

**Search not working:**
- Check if speakers exist and have searchable field data
- Verify form fields are marked as "searchable" in Form Builder
- Ensure attachments/images aren't interfering with results
- Security plugins may block search queries

**Geo search not appearing:**
- Verify "Enable geo/radius search" is checked in Directory Options
- Save settings and refresh page
- Run "Rebuild All Coordinates" in maintenance section
- Check that speakers have city/state/zip data

**Images not uploading or displaying:**
- Verify WordPress media library permissions
- Check PHP upload limits in hosting settings
- Ensure image field types are set correctly in Form Builder
- Test lightbox functionality on speaker profiles

**Authentication issues:**
- Verify /account-login/ page exists with [sb_login] shortcode
- Check user roles and capabilities
- Test password reset functionality
- Ensure /my-profile/ redirects work properly

**Templates not loading:**
- Check file permissions on plugin directory
- Verify custom post type is registered correctly
- Clear any caching plugins
- Check for theme conflicts

### Getting Help

**Check Logs:**
- WordPress debug log for PHP errors
- Browser console for JavaScript errors

**Plugin Support:**
- Review plugin documentation
- Check WordPress admin for error messages
- Test with default WordPress theme to isolate conflicts

## Security Considerations

1. **Two-Step Registration**: Email verification prevents spam registrations and ensures valid contact information
2. **File Uploads**: Images are uploaded to WordPress media library with type validation and security checks
3. **User Permissions**: Speakers can only edit their own profiles; admins have full access
4. **Data Validation**: All form inputs are sanitized and validated using WordPress functions
5. **CSRF Protection**: All forms use WordPress nonces for security
6. **Password Security**: New users create their own secure passwords during verification
7. **Role Management**: 'Speaker' role has limited permissions (no wp-admin access)
8. **Geo Data**: Location coordinates are stored securely and used only for distance calculations
9. **Contact Privacy**: Email and phone visibility can be controlled per field

## Performance Optimization

1. **Caching**: Plugin is compatible with standard WordPress caching plugins
2. **Database**: Uses efficient queries with proper indexing and prepared statements
3. **Images**: Automatically generates optimized thumbnails; lightbox loads full-size images on demand
4. **Geo Search**: Coordinates are cached to minimize OpenStreetMap API calls
5. **Search**: Uses database indexes for fast search results; attachments excluded for better performance
6. **Assets**: CSS and JavaScript only loaded on relevant pages
7. **Email Templates**: Template processing cached between requests

## Next Steps

After successful installation:

1. **Review SPEAKER-WALKTHROUGH.md** for end-user registration process
2. **Test two-step registration** to ensure email delivery works
3. **Configure form fields** and profile layout as needed
4. **Set up email templates** for your organization's communications
5. **Test all functionality** with sample speaker data
6. **Export configuration** as backup before making major changes
7. **Train users** on the new registration and profile management processes

## Available Shortcodes

- `[speaker_list]` - Display speaker directory with search and filtering
- `[speaker_register]` - Two-step registration form for new speakers
- `[speaker_edit]` - Profile editing form (requires authentication)
- `[sb_login]` - Frontend login form with password reset
- `[speaker_topics_index]` - Display organized index of all speaker topics

---

**Installation Complete!** Your Speakers Bureau v3.3 plugin is now ready with all advanced features including the new Topics Index block, fixed pagination, enhanced import system, auto-publish options, PHP 8.x compatibility, Yoast SEO support, privacy controls, enhanced email system, display customization, and anti-spam protection.