<?php
/**
 * File: includes/sb-notices.php
 * Purpose: Part of the Speakers Bureau plugin.
 */

if (!defined('ABSPATH')) exit;

function sb_migrate_form_fields() {
    $form_fields = get_option('sb_form_fields');
    if (is_array($form_fields)) {
        update_option('sb_form_fields', wp_json_encode($form_fields));
        set_transient('sb_form_fields_migrated', 1, HOUR_IN_SECONDS);
    }
}
add_action('plugins_loaded', 'sb_migrate_form_fields');

function sb_maybe_show_migration_notice() {
    if (!current_user_can('manage_options')) return;
    if (get_transient('sb_form_fields_migrated') && !get_user_meta(get_current_user_id(), 'sb_migration_notice_dismissed', true)) {
        $dismiss_url = wp_nonce_url(add_query_arg('sb_dismiss_migration', '1'), 'sb_dismiss_migration');
        echo '<div class="notice notice-success is-dismissible">
                <p><strong>Speakers Bureau:</strong> '.esc_html__('Form fields were migrated successfully.','sb').'</p>
                <p><a href="'.esc_url($dismiss_url).'" class="button">'.esc_html__('Dismiss','sb').'</a></p>
              </div>';
        delete_transient('sb_form_fields_migrated');
    }
}
add_action('admin_notices', 'sb_maybe_show_migration_notice');

function sb_handle_dismiss_notice() {
    if (!current_user_can('manage_options')) return;
    if (isset($_GET['sb_dismiss_migration']) && wp_verify_nonce($_GET['_wpnonce'] ?? '', 'sb_dismiss_migration')) {
        update_user_meta(get_current_user_id(), 'sb_migration_notice_dismissed', 1);
    }
}
add_action('admin_init', 'sb_handle_dismiss_notice');

/** END OF FILE: includes/sb-notices.php */
