<?php
/**
 * Temporary script to flush rewrite rules for speaker verification
 * Run this once to register the new speaker-verify URL
 */

// Load WordPress
require_once '../../../wp-load.php';

// Check if user has admin permissions
if (!current_user_can('manage_options')) {
    die('Access denied');
}

// Add the rewrite rule
add_rewrite_rule('^speaker-verify/?$', 'index.php?speaker_verify=1', 'top');

// Flush rewrite rules
flush_rewrite_rules();

echo 'Rewrite rules flushed successfully! The speaker-verify URL should now work.';
?>