<?php
/**
 * File: includes/sb-geocoding.php
 * Purpose: Part of the Speakers Bureau plugin.
 */

if (!defined('ABSPATH')) exit;

function sb_geocode_address($address) {
    $api_url = "https://nominatim.openstreetmap.org/search?" . http_build_query([
        'q' => $address,
        'format' => 'json',
        'limit' => 1
    ]);
    $response = wp_remote_get($api_url, ['headers'=>['User-Agent'=>'Speakers Bureau Plugin']]);
    if (is_wp_error($response)) return false;
    $data = json_decode(wp_remote_retrieve_body($response), true);
    if (!empty($data[0])) {
        return ['lat'=>$data[0]['lat'], 'lng'=>$data[0]['lon']];
    }
    return false;
}

// Geocode on save
add_action('save_post_speaker', function($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    $address = get_post_meta($post_id, 'sb_address', true);
    $city    = get_post_meta($post_id, 'sb_city', true);
    $state   = get_post_meta($post_id, 'sb_state', true);
    $zip     = get_post_meta($post_id, 'sb_zip', true);

    $parts = array_filter([$address, $city, $state, $zip]);
    if (!$parts) return;
    $full_address = implode(', ', $parts);

    $coords = sb_geocode_address($full_address);
    if ($coords) {
        update_post_meta($post_id, 'geo_lat', $coords['lat']);
        update_post_meta($post_id, 'geo_lng', $coords['lng']);
        // Also update old format for backward compatibility
        update_post_meta($post_id, '_sb_lat', $coords['lat']);
        update_post_meta($post_id, '_sb_lng', $coords['lng']);
    }
});

/** END OF FILE: includes/sb-geocoding.php */
