<?php
/**
 * File: includes/sb-assets.php
 * Function: Enqueue CSS/JS for admin and frontend (including Media Uploader support)
 */
if (!defined('ABSPATH')) exit;

/**
 * Admin asset loader
 */
function sb_enqueue_admin_assets($hook) {
    // Hooks where admin scripts are needed
    $pages = [
        'speaker_page_sb-settings',       // Settings under Speakers
        'settings_page_sb-form-builder',  // Form Builder under Settings
        'post.php',                       // Speaker edit screen
        'post-new.php',                   // New Speaker screen
    ];

    if (in_array($hook, $pages, true)) {
        // Ensure WP media uploader is available
        wp_enqueue_media();

        // Admin JS
        wp_enqueue_script(
            'sb-admin-js',
            SB_PLUGIN_URL . 'assets/sb-admin.js',
            ['jquery','jquery-ui-sortable'],
            SB_PLUGIN_VER,
            true
        );

        // Admin CSS
        wp_enqueue_style(
            'sb-admin-css',
            SB_PLUGIN_URL . 'assets/sb-admin.css',
            [],
            SB_PLUGIN_VER
        );
    }
}
add_action('admin_enqueue_scripts', 'sb_enqueue_admin_assets');

/**
 * Frontend asset loader
 */
function sb_enqueue_frontend_assets() {
    // Check if we're on a speaker-related page or page with speaker shortcodes
    $should_load = false;

    if (is_singular('speaker') || is_post_type_archive('speaker')) {
        $should_load = true;
    } else {
        // Check if current page has speaker shortcodes
        global $post;
        if ($post && (has_shortcode($post->post_content, 'speaker_list') ||
            has_shortcode($post->post_content, 'speaker_register') ||
            has_shortcode($post->post_content, 'speaker_edit'))) {
            $should_load = true;
        }
    }

    if (!$should_load) {
        return;
    }

    // Ensure WP media uploader is available on the front-end
    wp_enqueue_media();

    // Font Awesome CSS for icons
    wp_enqueue_style(
        'font-awesome',
        'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css',
        [],
        '6.4.0'
    );

    // Frontend CSS
    wp_enqueue_style(
        'sb-frontend',
        SB_PLUGIN_URL . 'assets/sb-frontend.css',
        ['font-awesome'],
        SB_PLUGIN_VER
    );

    // Frontend JS
    wp_enqueue_script(
        'sb-frontend-js',
        SB_PLUGIN_URL . 'assets/sb-frontend.js',
        ['jquery'],
        SB_PLUGIN_VER,
        true
    );
}
add_action('wp_enqueue_scripts', 'sb_enqueue_frontend_assets');

/* End of file: includes/sb-assets.php */

/** END OF FILE: includes/sb-assets.php */
