/**
 * File: assets/sb-frontend.js
 * Function: Front-end behaviors (media upload for image fields, minor UX)
 */
(function($){
  $(document).ready(function(){

    // Front-end Media Uploader for .sb-upload-btn
    var sbMediaFrame = null;

    function openMedia(frameTitle, inputEl) {
      if (sbMediaFrame) {
        sbMediaFrame.off('select'); // remove previous listener
      }

      sbMediaFrame = wp.media({
        title: frameTitle || 'Select or Upload Image',
        button: { text: 'Use this image' },
        multiple: false
      });

      sbMediaFrame.on('select', function(){
        var attachment = sbMediaFrame.state().get('selection').first().toJSON();
        // Find the text input in the same .sb-upload wrapper
        var $wrapper = $(inputEl).closest('.sb-upload');
        var $input = $wrapper.find('input[type="text"]');
        if ($input.length) {
          $input.val(attachment.url).trigger('change');
        }
      });

      sbMediaFrame.open();
    }

    $(document).on('click', '.sb-upload-btn', function(e){
      e.preventDefault();
      if (typeof wp === 'undefined' || !wp.media) {
        alert('The WordPress Media Library is not available on this page.');
        return;
      }
      openMedia('Select Image', this);
    });

  });
})(jQuery);

/* End of file: assets/sb-frontend.js */
// END OF FILE
