/**
 * File: assets/sb-admin.js
 * Function: Admin-side JS for Speakers Bureau (Form Builder controls)
 */
jQuery(document).ready(function($){

  // Make form builder rows sortable
  $('#sb-form-builder tbody').sortable({
    handle: '.dashicons-move',
    helper: function(e, tr) {
      var originals = tr.children();
      var helper = tr.clone();
      helper.children().each(function(i){
        $(this).width(originals.eq(i).width());
      });
      return helper;
    }
  });

  /**
   * Add Field button
   */
  $('#sb-add-field').on('click', function(e){
    e.preventDefault();

    var $tbody = $('#sb-form-builder tbody');
    var rowCount = $tbody.find('tr').length;
    var newIndex = rowCount;

    // Template for a new row
    var newRow = `
      <tr>
        <td><input type="text" name="sb_form_fields[${newIndex}][label]" value="" /></td>
        <td><input type="text" name="sb_form_fields[${newIndex}][key]" value="" /></td>
        <td>
          <select name="sb_form_fields[${newIndex}][type]">
            <option value="text">Text</option>
            <option value="email">Email</option>
            <option value="url">URL</option>
            <option value="tel">Phone</option>
            <option value="textarea">Textarea</option>
            <option value="image">Image</option>
            <option value="section_header">Section Header</option>
            <option value="checkbox">Checkbox</option>
            <option value="number">Number</option>
            <option value="select">Select</option>
          </select>
        </td>
        <td>
          <label><input type="checkbox" name="sb_form_fields[${newIndex}][enabled]" value="1"> Enabled</label><br>
          <label><input type="checkbox" name="sb_form_fields[${newIndex}][card]" value="1"> Show on Directory Card</label><br>
          <label><input type="checkbox" name="sb_form_fields[${newIndex}][required]" value="1"> Required Field</label><br>
          <label><input type="checkbox" name="sb_form_fields[${newIndex}][show_section]" value="1"> Show Header on Profile Page</label><br>
          <label><input type="checkbox" name="sb_form_fields[${newIndex}][featured]" value="1"> Use as Featured Image</label>
        </td>
        <td style="text-align:center;"><span class="dashicons dashicons-move" style="cursor:move;"></span></td>
        <td style="text-align:center;">
          <button type="button" class="button button-link-delete sb-delete-row" title="Delete field">
            <span class="dashicons dashicons-trash"></span>
          </button>
        </td>
      </tr>
    `;

    $tbody.append(newRow);
  });

  /**
   * Delete row
   */
  $(document).on('click', '.sb-delete-row', function(e){
    e.preventDefault();
    if (confirm('Are you sure you want to delete this field?')) {
      $(this).closest('tr').remove();
    }
  });

});
/* End of file: assets/sb-admin.js */
// END OF FILE
