# Speakers Bureau Plugin - User Guide

## Table of Contents
1. [Overview](#overview)
2. [Finding Speakers](#finding-speakers)
3. [Speaker Registration](#speaker-registration)
4. [Managing Your Profile](#managing-your-profile)
5. [Administrator Features](#administrator-features)
6. [Troubleshooting](#troubleshooting)

## Overview

The Speakers Bureau plugin provides a comprehensive system for managing speaker directories, allowing organizations to:

- **Browse speakers** by topic, location, and other criteria
- **Register new speakers** with detailed profiles
- **Search speakers** using keywords and geo-location
- **Manage profiles** with image uploads and custom fields
- **Organize information** with flexible form builder and layout options

## Finding Speakers

### Speaker Directory Page

Visit your site's speaker directory (typically `/speakers/` or `/browse-speakers/`) to explore available speakers.

#### Basic Search
1. **Keyword Search**: Enter any term in the search box
   - Searches across speaker names, topics, organizations, bios, and other searchable fields
   - Results update automatically to show matching speakers

2. **Sort Options**:
   - **Newest**: Recently added speakers first
   - **Default**: Standard chronological order
   - **Nearest**: Sort by distance (requires location search)

#### Location-Based Search

If geo-location search is enabled, you'll see additional options:

1. **Click "Location..." button** to expand geo search form
2. **Enter search criteria**:
   - **ZIP Code**: Enter postal code for search center
   - **Country**: Two-letter country code (e.g., US, CA, GB)
   - **Radius**: Search distance in miles
3. **Select "Nearest"** from sort dropdown to order by distance
4. **Click "Apply"** to search

**Results will show**:
- Speakers within specified radius
- Distance from your search location
- Sorted by proximity when "Nearest" is selected

### Speaker Profiles

Click any speaker card to view their detailed profile:

#### Profile Sections
- **Profile Summary**: Photo, headline, and key details
- **Overview**: Speaker bio and background
- **Topics**: Speaking topics and expertise areas
- **Background**: Professional history and credentials
- **More Information**: Additional details and contact info

#### Contact Information
- Email addresses (if public)
- Phone numbers (if provided)
- Website links
- Social media profiles

## Speaker Registration

### Becoming a Speaker

1. **Visit Registration Page**: Go to `/speaker-register/` or `/register-as-speaker/`
2. **Complete Registration Form**: Fill out all required fields
3. **Upload Photos**: Add profile image and topic images
4. **Submit Application**: Click submit to create your profile

### Registration Form Fields

**Required Fields** (marked with *):
- **Name**: Your full name
- **Email**: Contact email address
- **Headline**: Brief description of your expertise
- **Bio**: Detailed background and experience

**Optional Fields**:
- **Profile Image**: Professional headshot
- **Organization**: Company or affiliation
- **Topics**: Speaking topics and areas of expertise
- **Topic Images**: Visual representations of your topics
- **Phone**: Contact phone number
- **Website**: Personal or professional website
- **City/State**: Location information
- **Summary**: Brief overview of speaking experience

### Image Upload Guidelines

**Profile Image**:
- **Format**: JPG, PNG, or GIF
- **Size**: Recommended 400x400 pixels minimum
- **Quality**: High resolution for best display
- **Content**: Professional headshot

**Topic Images**:
- **Purpose**: Visual representation of speaking topics
- **Format**: JPG, PNG, or GIF
- **Size**: Recommended 400x300 pixels
- **Content**: Relevant to your speaking topics

### After Registration

1. **Confirmation**: Success message confirms registration
2. **Profile Review**: Profile appears in speaker directory
3. **Email Notification**: Confirmation email sent (if configured)
4. **Profile Access**: Use "My Profile" page to make updates

## Managing Your Profile

### Accessing Your Profile

**Edit Profile Page**: Visit `/my-profile/` to manage your speaker information

**Authentication**: You may need to log in or provide identification to access your profile

### Updating Information

#### Profile Fields
1. **Navigate to "My Profile" page**
2. **Update any field**:
   - Change text in input fields
   - Upload new images using "Upload" buttons
   - Modify dropdown selections
3. **Save Changes**: Click "Save Changes" button

#### Image Management

**Uploading New Images**:
1. **Click "Upload" button** next to image field
2. **Select file** from your computer
3. **Confirm selection** - preview appears
4. **Save profile** to apply changes

**Replacing Images**:
1. **Click "Replace" button** next to existing image
2. **Select new file** from computer
3. **Confirm replacement**
4. **Save profile** to update

**Removing Images**:
1. **Click "Remove" button** next to image
2. **Confirm removal**
3. **Save profile** to apply changes

### Profile Visibility

**Public Information**:
- Name and headline (always visible)
- Bio and speaking topics
- Profile and topic images
- Fields marked as public in form configuration

**Private Information**:
- Contact details may be hidden based on configuration
- Administrative fields not shown to public
- Edit access restricted to profile owner

### Profile Preview

**View Public Profile**:
1. **Save your changes** first
2. **Visit speaker directory** page
3. **Search for your name** or browse listings
4. **Click your profile card** to see public view

## Administrator Features

### Plugin Settings Access

**Navigation**: WordPress Admin → Speakers Bureau

### Directory Options

**Search Configuration**:
- **Enable geo/radius search**: Allow location-based searching
- **Default country**: Set default country for geo searches
- **Default radius**: Set default search radius in miles
- **Enable "Nearest" sort**: Add distance-based sorting option

**Maintenance Tools**:
- **Create Required Pages**: Automatically generate necessary pages
- **Rebuild Coordinates**: Update geo-location data for all speakers
- **Data Management**: Bulk operations and cleanup tools

### Form Builder

**Field Management**:
1. **Access Form Builder**: Speakers Bureau → Form Builder
2. **Add New Fields**: Click "Add field" button
3. **Configure Fields**:
   - **Label**: Display name for field
   - **Key**: Internal identifier (no spaces)
   - **Type**: text, textarea, email, url, image, select, etc.
   - **Placeholder**: Helper text for users
   - **Section**: Which profile section to display in (1-8)
   - **Required**: Make field mandatory
   - **Searchable**: Include in search functionality
   - **Hide Label**: Show only field value, not label

4. **Field Types Available**:
   - **text**: Single-line text input
   - **textarea**: Multi-line text area
   - **email**: Email address with validation
   - **url**: Website URL with validation
   - **phone**: Phone number input
   - **image**: Image upload field
   - **select**: Dropdown selection
   - **checkbox**: Multiple choice options
   - **section_header**: Visual section divider

5. **Save Form**: Click "Save Form" to apply changes

### Profile Layout

**Section Configuration**:
1. **Access Layout**: Speakers Bureau → Profile Layout
2. **Configure 8 Sections**:
   - **Section 1**: Profile summary (left column with image)
   - **Section 2**: Overview (right column)
   - **Section 3**: Topics (right column)
   - **Section 4**: Background (right column)
   - **Section 5-6**: Custom sections (right column)
   - **Section 7**: More information (full width)
   - **Section 8**: Private/admin fields (hidden from public)

3. **Section Settings**:
   - **Title**: Section heading text
   - **Heading Tag**: HTML heading level (h1-h6)
   - **Display**: Show or hide section title
   - **Hidden**: Hide entire section from public view

### Email Templates

**Template Configuration**:
1. **Access Templates**: Speakers Bureau → Email Templates
2. **Available Templates**:
   - **Registration Confirmation**: Sent to new speakers
   - **Profile Update**: Sent when profiles are modified
   - **Admin Notification**: Sent to administrators

3. **Email Placeholders**:
   - `{name}`: Speaker's name
   - `{email}`: Speaker's email
   - `{profile_url}`: Link to public profile
   - `{edit_url}`: Link to edit profile
   - `{site_name}`: WordPress site name
   - `{date}`: Current date

### Speaker Management

**Admin Speaker List**:
1. **Access**: WordPress Admin → Speakers (custom post type)
2. **View All Speakers**: Browse, search, and filter speakers
3. **Edit Individual Profiles**: Click speaker name to edit
4. **Bulk Operations**: Select multiple speakers for bulk actions
5. **Custom Columns**: View key information in list format

**Speaker Profile Editing**:
- **Full field access**: Edit all profile fields
- **Meta box interface**: Organized by sections
- **Image management**: Upload, replace, remove images
- **Status control**: Publish, draft, or private profiles
- **SEO optimization**: Custom URLs and meta descriptions

## Troubleshooting

### Common Issues and Solutions

#### Search Not Working
**Problem**: Search returns no results despite existing speakers
**Solutions**:
1. **Check searchable fields**: Ensure fields are marked "searchable" in Form Builder
2. **Verify speaker data**: Confirm speakers have data in searchable fields
3. **Test with different terms**: Try searching for known values
4. **Check security plugins**: Some security plugins interfere with search queries

#### Geo Location Search Not Appearing
**Problem**: "Location..." button not visible
**Solutions**:
1. **Check settings**: Verify "Enable geo/radius search" is checked
2. **Save settings**: Ensure settings are saved and page is refreshed
3. **Clear cache**: Clear any caching plugins
4. **Check coordinates**: Verify speakers have geo coordinates

#### Images Not Uploading
**Problem**: Image upload fails or doesn't work
**Solutions**:
1. **Check file size**: Ensure images are under upload limit
2. **Verify format**: Use JPG, PNG, or GIF formats
3. **Check permissions**: Verify WordPress media upload permissions
4. **Field type**: Ensure field type is set to "image" in Form Builder

#### Profile Edit Access Issues
**Problem**: Can't access profile editing page
**Solutions**:
1. **Check URL**: Verify "/my-profile/" page exists
2. **Authentication**: Ensure proper user identification method
3. **Page content**: Confirm page contains `[speaker_edit]` shortcode
4. **Permissions**: Check user capabilities and access controls

#### Form Builder Fields Reverting
**Problem**: Field types reset to "text" after saving
**Solutions**:
1. **Save carefully**: Ensure all field types are set before saving
2. **Check JavaScript**: Browser errors may prevent proper form submission
3. **Plugin conflicts**: Deactivate other plugins to test for conflicts
4. **Clear cache**: Clear any optimization or caching plugins

### Getting Additional Help

**Debug Information**:
1. **Enable WordPress debug mode** for detailed error messages
2. **Check browser console** for JavaScript errors
3. **Review error logs** for PHP warnings or errors
4. **Test with default theme** to isolate theme conflicts

**Support Resources**:
- Plugin documentation and guides
- WordPress community forums
- Contact site administrator for technical issues
- Review changelog for recent updates and fixes

### Performance Tips

**Optimization Strategies**:
1. **Image sizes**: Use appropriate image dimensions to reduce load times
2. **Caching**: Enable caching plugins for better performance
3. **Search optimization**: Limit searchable fields to essential information only
4. **Regular maintenance**: Periodically rebuild geo coordinates for accuracy
5. **Database cleanup**: Remove unused or outdated speaker profiles

---

**Need More Help?** Contact your site administrator or refer to the installation guide for technical details.