# Speakers Bureau Plugin - Administrator Guide

## Quick Reference

### Essential Admin Tasks
- **Access Plugin**: WordPress Admin → Speakers Bureau
- **Manage Speakers**: WordPress Admin → Speakers
- **View Directory**: Visit `/speakers/` page
- **Form Configuration**: Speakers Bureau → Form Builder
- **Settings**: Speakers Bureau → Directory Options

## Daily Administration

### Managing Speakers

#### Speaker List View
**Location**: WordPress Admin → Speakers

**Available Actions**:
- **View**: See all registered speakers in table format
- **Edit**: Click speaker name to edit profile
- **Quick Edit**: Inline editing for basic fields
- **Bulk Actions**: Select multiple speakers for bulk operations
- **Search/Filter**: Find specific speakers quickly

**Custom Columns Displayed**:
- Speaker name and headline
- Organization and topics
- Registration date
- Profile status (published/draft)
- Contact information
- Location data

#### Editing Individual Speakers

**Access**: Click speaker name in admin list

**Available Fields** (organized in meta boxes):
- **Profile Information**: Name, headline, bio
- **Contact Details**: Email, phone, website
- **Topics & Expertise**: Speaking topics and topic images
- **Location**: Address and geo coordinates
- **Images**: Profile photo and topic visuals
- **Custom Fields**: Any additional configured fields

**Image Management**:
- **Upload**: Select files from media library or upload new
- **Replace**: Change existing images
- **Remove**: Delete images from profile
- **Preview**: View images as they appear on profile

#### Speaker Status Control
- **Published**: Visible in public directory
- **Draft**: Hidden from public, admin-only access
- **Private**: Restricted visibility
- **Trash**: Soft delete (recoverable)

### Form Builder Management

#### Accessing Form Builder
**Location**: Speakers Bureau → Form Builder

#### Field Configuration

**Adding New Fields**:
1. Click **"Add field"** button
2. Configure field properties:
   - **Label**: Display name for users
   - **Key**: Internal identifier (lowercase, no spaces)
   - **Type**: Select from available field types
   - **Placeholder**: Helper text for users
   - **Section**: Profile section number (1-8)
3. Set field options:
   - **Enabled**: Include in forms
   - **Required**: Make mandatory
   - **Searchable**: Include in search functionality
   - **Hide Label**: Show only value, not label
4. Click **"Save Form"**

**Field Types Available**:
- **text**: Single-line text input
- **textarea**: Multi-line text area
- **email**: Email with validation
- **url**: Website URL with validation
- **phone**: Phone number input
- **image**: Image upload capability
- **select**: Dropdown selection
- **checkbox**: Multiple choice options
- **section_header**: Visual section divider
- **edit_link**: Special profile editing link

**Reordering Fields**:
- Drag and drop rows to reorder
- Order affects display on registration and edit forms
- Profile display order controlled by section assignments

**Field Management Best Practices**:
- Use clear, descriptive labels
- Keep field keys consistent (no special characters)
- Mark essential fields as required
- Enable search for relevant fields only
- Test forms after making changes

### Profile Layout Configuration

#### Section Organization
**Location**: Speakers Bureau → Profile Layout

**8 Available Sections**:
1. **Section 1**: Profile summary (left column, with image)
2. **Section 2**: Overview (right column)
3. **Section 3**: Topics (right column)
4. **Section 4**: Background (right column)
5. **Section 5**: Custom section (right column)
6. **Section 6**: Custom section (right column)
7. **Section 7**: More information (full width bottom)
8. **Section 8**: Private/admin fields (hidden from public)

**Section Settings**:
- **Title**: Section heading text
- **Heading Tag**: HTML level (h1, h2, h3, h4, h5, h6)
- **Display**: Show/hide section title
- **Hidden**: Hide entire section from public view

**Layout Strategy**:
- Section 1: Key information and photo
- Sections 2-4: Main content areas
- Sections 5-6: Additional/optional content
- Section 7: Contact info and links
- Section 8: Internal notes and admin data

### Directory Options & Settings

#### Basic Settings
**Location**: Speakers Bureau → Directory Options

**Search Configuration**:
- **☑️ Enable geo/radius search**: Location-based searching
- **☑️ Enable "Nearest" sort**: Distance-based sorting
- **Default country code**: Two-letter code (US, CA, GB, etc.)
- **Default radius (miles)**: Default search distance

**Page Management**:
- **Auto-create pages**: Generate required pages automatically
- **Manual setup**: Create pages with proper shortcodes

#### Maintenance Tools

**Bulk Operations**:
- **"Create Required Pages"**: Generate speaker directory, registration, and profile edit pages
- **"Rebuild All Coordinates"**: Update geo-location data for all speakers
- **Data cleanup**: Remove orphaned or invalid data

**Geo Coordinate Management**:
- **When to rebuild**: After bulk speaker imports, address changes, or geo search issues
- **Process**: Converts address data to latitude/longitude coordinates
- **API usage**: Uses OpenStreetMap Nominatim service
- **Caching**: Results cached for performance

### Email Template Configuration

#### Template Management
**Location**: Speakers Bureau → Email Templates

**Available Templates**:
1. **Registration Confirmation**: Sent to new speakers
2. **Profile Update Notification**: Sent when profiles change
3. **Admin Notification**: Sent to administrators

**Email Placeholders**:
- `{name}`: Speaker's full name
- `{email}`: Speaker's email address
- `{profile_url}`: Link to public speaker profile
- `{edit_url}`: Link to profile editing page
- `{site_name}`: WordPress site name
- `{date}`: Current date/time
- `{organization}`: Speaker's organization
- `{topics}`: Speaker's topics list

**Template Best Practices**:
- Use clear, professional language
- Include relevant action links
- Test emails after changes
- Consider mobile email clients
- Include unsubscribe options if required

## Advanced Administration

### Database Management

#### Speaker Data Structure
**Custom Post Type**: `speaker`
**Meta Fields**: Stored in `wp_postmeta` table
**Geo Data**: `geo_lat` and `geo_lng` meta fields
**Form Configuration**: `sb_form_fields` option
**Plugin Settings**: `sb_settings` option

#### Data Import/Export
**Manual Import**:
- Create speakers via WordPress admin
- Use CSV import plugins (configure meta field mapping)
- Bulk operations via wp-admin

**Data Export**:
- WordPress standard export functionality
- Custom queries for specific data sets
- Backup before major changes

### Security Considerations

#### User Access Control
- **Public Registration**: Open to all users
- **Profile Editing**: Restricted to profile owners
- **Admin Access**: Full control over all profiles
- **Search Access**: Public directory viewing

#### Data Protection
- **Image Uploads**: Validated file types and sizes
- **Form Input**: Sanitized and validated data
- **Email Privacy**: Configurable contact information visibility
- **Geo Data**: Used only for distance calculations

#### Security Best Practices
- Regular plugin updates
- Strong admin passwords
- Limit admin user accounts
- Monitor for suspicious activity
- Regular data backups

### Performance Optimization

#### Database Optimization
- **Indexing**: Automatic meta field indexing for search
- **Query Optimization**: Efficient speaker queries
- **Caching**: Geo-coordinate result caching
- **Cleanup**: Remove unused meta data

#### Front-end Performance
- **Image Optimization**: Automatic thumbnail generation
- **Search Efficiency**: Indexed field searching
- **Pagination**: Limit results per page
- **Caching Compatibility**: Works with standard WordPress caching

#### Monitoring
- **Search Performance**: Monitor search response times
- **Geo API Usage**: Track external geocoding requests
- **Image Storage**: Monitor media library usage
- **User Activity**: Track registration and profile updates

### Troubleshooting Common Issues

#### Search Problems
**Issue**: Search returns no results
**Solutions**:
1. Check if speakers have data in searchable fields
2. Verify searchable fields are enabled in Form Builder
3. Test with known data values
4. Check for plugin conflicts
5. Review security plugin settings

#### Geo Location Issues
**Issue**: Location search not working
**Solutions**:
1. Verify geo search is enabled in settings
2. Check speaker addresses are complete
3. Rebuild coordinates using maintenance tool
4. Test with known ZIP codes
5. Verify API connectivity

#### Image Upload Problems
**Issue**: Images not uploading or displaying
**Solutions**:
1. Check WordPress upload limits
2. Verify file permissions
3. Test image file formats (JPG, PNG, GIF)
4. Clear plugin/theme caches
5. Check field types in Form Builder

#### Form Builder Reversion
**Issue**: Field types reset to "text"
**Solutions**:
1. Save form carefully after setting all field types
2. Check for JavaScript errors in browser console
3. Test for plugin conflicts
4. Verify browser compatibility
5. Clear optimization plugin caches

### Backup and Recovery

#### Regular Backup Strategy
- **Full Site Backups**: Include files and database
- **Plugin Settings**: Export form configurations
- **Speaker Data**: Regular database exports
- **Media Files**: Backup speaker images
- **Testing**: Verify backup restoration process

#### Recovery Procedures
- **Settings Recovery**: Restore form builder configuration
- **Data Recovery**: Import speaker profiles from backup
- **Image Recovery**: Restore media library files
- **Configuration**: Reconfigure plugin settings
- **Testing**: Verify all functionality after recovery

### Integration and Extensions

#### WordPress Integration
- **Custom Post Types**: Seamless WordPress integration
- **Media Library**: Standard image handling
- **User Management**: WordPress user system compatibility
- **SEO**: Search engine friendly URLs and content
- **Themes**: Compatible with most WordPress themes

#### Third-party Compatibility
- **Caching Plugins**: WP Rocket, W3 Total Cache, etc.
- **SEO Plugins**: Yoast, RankMath, etc.
- **Security Plugins**: Wordfence, Sucuri, etc.
- **Form Plugins**: Contact Form 7, Gravity Forms, etc.
- **Page Builders**: Elementor, Beaver Builder, etc.

### Monitoring and Analytics

#### Usage Analytics
- **Speaker Registration**: Track new registrations
- **Search Activity**: Monitor search usage patterns
- **Profile Views**: Track speaker profile visits
- **Geographic Distribution**: Analyze speaker locations
- **Form Completion**: Monitor registration success rates

#### Performance Metrics
- **Page Load Times**: Monitor directory page performance
- **Search Response**: Track search query performance
- **Image Loading**: Monitor image optimization effectiveness
- **Database Performance**: Watch query execution times
- **API Usage**: Track geocoding service usage

---

## Quick Command Reference

### Essential URLs
- **Admin Dashboard**: `/wp-admin/`
- **Plugin Settings**: `/wp-admin/admin.php?page=sb-settings`
- **Speaker Management**: `/wp-admin/edit.php?post_type=speaker`
- **Form Builder**: `/wp-admin/admin.php?page=sb-settings&tab=form_builder`
- **Speaker Directory**: `/speakers/`
- **Registration Page**: `/speaker-register/`
- **Profile Edit**: `/my-profile/`

### Important Shortcodes
- `[speaker_list]`: Display speaker directory
- `[speaker_register]`: Registration form
- `[speaker_edit]`: Profile editing form

### Key Database Tables
- `wp_posts`: Speaker profiles (post_type = 'speaker')
- `wp_postmeta`: Speaker field data
- `wp_options`: Plugin settings and form configuration

This guide provides comprehensive administration information for the Speakers Bureau plugin. For technical installation details, refer to the Installation Guide.